/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;

public class ConcurrentJobsHelper {
    private static ConcurrentHashMap<String, ConcurrentBuild> concurrentBuildHandler = new ConcurrentHashMap();

    private static String getConcurrentBuildJobId(AbstractBuild build) {
        return BuildUniqueIdentifierHelper.getBuildName((Run)build) + "." + build.getNumber();
    }

    public static ConcurrentBuild getConcurrentBuild(AbstractBuild build) {
        return concurrentBuildHandler.get(ConcurrentJobsHelper.getConcurrentBuildJobId(build));
    }

    public static void removeConcurrentBuildJob(AbstractBuild build) {
        concurrentBuildHandler.remove(ConcurrentJobsHelper.getConcurrentBuildJobId(build));
    }

    public static class ConcurrentBuild {
        private AtomicInteger threadsCounter;
        private boolean initialized = false;
        private ConcurrentHashMap<String, String> params = new ConcurrentHashMap();

        public ConcurrentBuild(AtomicInteger threadsCounter) {
            this.threadsCounter = threadsCounter;
        }

        public void putParam(String name, String value) {
            this.params.put(name, value);
        }

        public String getParam(String name) {
            return this.params.get(name);
        }

        public AtomicInteger getThreadsCounter() {
            return this.threadsCounter;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public void setAsInitialized() {
            this.initialized = true;
        }
    }

    public static abstract class ConcurrentBuildTearDownSync {
        public ConcurrentBuildTearDownSync(AbstractBuild build, Result buildResult) {
            ConcurrentBuild concurrentBuild = (ConcurrentBuild)concurrentBuildHandler.get(ConcurrentJobsHelper.getConcurrentBuildJobId(build));
            if (concurrentBuild.getThreadsCounter().decrementAndGet() == 0 || Result.ABORTED.equals(buildResult)) {
                this.tearDown();
                ConcurrentJobsHelper.removeConcurrentBuildJob(build);
            }
        }

        public abstract void tearDown();
    }

    public static abstract class ConcurrentBuildSetupSync {
        public ConcurrentBuildSetupSync(AbstractBuild build, int totalBuilds) {
            ConcurrentBuild newBuild = new ConcurrentBuild(new AtomicInteger(totalBuilds));
            ConcurrentBuild existingBuild = concurrentBuildHandler.putIfAbsent(ConcurrentJobsHelper.getConcurrentBuildJobId(build), newBuild);
            ConcurrentBuild concurrentBuild = existingBuild = existingBuild == null ? newBuild : existingBuild;
            if (totalBuilds == 1) {
                this.setUp();
            } else {
                this.setupMultiBuild(existingBuild);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setupMultiBuild(ConcurrentBuild build) {
            if (!build.isInitialized()) {
                ConcurrentBuild concurrentBuild = build;
                synchronized (concurrentBuild) {
                    if (!build.isInitialized()) {
                        this.setUp();
                        build.setAsInitialized();
                    }
                }
            }
        }

        public abstract void setUp();
    }
}

