/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm.svn;

import hudson.FilePath;
import hudson.maven.agent.AbortException;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.SubversionSCM;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.jfrog.hudson.release.scm.AbstractScmManager;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SubversionManager
extends AbstractScmManager<SubversionSCM> {
    private static Logger debuggingLogger = Logger.getLogger(SubversionManager.class.getName());

    public SubversionManager(AbstractBuild<?, ?> abstractBuild, TaskListener buildListener) {
        super(abstractBuild, buildListener);
    }

    public void prepare() {
    }

    @Override
    public void commitWorkingCopy(String commitMessage) throws IOException, InterruptedException {
        this.build.getWorkspace().act((FilePath.FileCallable)new SVNCommitWorkingCopyCallable(commitMessage, this.getLocation(), this.getSvnAuthenticationProvider(this.build), this.buildListener));
    }

    @Override
    public void createTag(String tagUrl, String commitMessage) throws IOException, InterruptedException {
        this.build.getWorkspace().act((FilePath.FileCallable)new SVNCreateTagCallable(tagUrl, commitMessage, this.getLocation(), this.getSvnAuthenticationProvider(this.build), this.buildListener));
    }

    public void revertWorkingCopy() throws IOException, InterruptedException {
        this.build.getWorkspace().act((FilePath.FileCallable)new RevertWorkingCopyCallable(this.getLocation(), this.getSvnAuthenticationProvider(this.build), this.buildListener));
    }

    public void safeRevertWorkingCopy() {
        block7: {
            try {
                this.revertWorkingCopy();
            }
            catch (Exception e) {
                debuggingLogger.log(Level.FINE, "Failed to revert working copy", e);
                this.log("Failed to revert working copy: " + e.getLocalizedMessage());
                Throwable cause = e.getCause();
                if (!(cause instanceof SVNException)) {
                    return;
                }
                SVNException svnException = (SVNException)cause;
                if (svnException.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LOCKED) break block7;
                try {
                    this.cleanupWorkingCopy();
                }
                catch (Exception unlockException) {
                    debuggingLogger.log(Level.FINE, "Failed to cleanup working copy", e);
                    this.log("Failed to cleanup working copy: " + e.getLocalizedMessage());
                    return;
                }
                try {
                    this.revertWorkingCopy();
                }
                catch (Exception revertException) {
                    this.log("Failed to revert working copy on the 2nd attempt: " + e.getLocalizedMessage());
                }
            }
        }
    }

    private void cleanupWorkingCopy() throws IOException, InterruptedException {
        this.build.getWorkspace().act((FilePath.FileCallable)new CleanupCallable(this.getLocation(), this.getSvnAuthenticationProvider(this.build), this.buildListener));
    }

    public void safeRevertTag(String tagUrl, String commitMessageSuffix) {
        try {
            this.log("Reverting subversion tag: " + tagUrl);
            SVNURL svnUrl = SVNURL.parseURIEncoded((String)tagUrl);
            SVNCommitClient commitClient = new SVNCommitClient(this.createAuthenticationManager(), null);
            SVNCommitInfo commitInfo = commitClient.doDelete(new SVNURL[]{svnUrl}, "[artifactory-release] " + commitMessageSuffix);
            SVNErrorMessage errorMessage = commitInfo.getErrorMessage();
            if (errorMessage != null) {
                this.log("Failed to revert '" + tagUrl + "': " + errorMessage.getFullMessage());
            }
        }
        catch (SVNException e) {
            this.log("Failed to revert '" + tagUrl + "': " + e.getLocalizedMessage());
        }
    }

    @Override
    public String getRemoteUrl(String defaultRemoteUrl) {
        return this.getLocation().remote;
    }

    public SubversionSCM.ModuleLocation getLocation() {
        return ((SubversionSCM)this.getJenkinsScm()).getLocations()[0];
    }

    private ISVNAuthenticationManager createAuthenticationManager() {
        ISVNAuthenticationProvider sap = this.getSvnAuthenticationProvider(this.build);
        ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
        sam.setAuthenticationProvider(sap);
        return sam;
    }

    private ISVNAuthenticationProvider getSvnAuthenticationProvider(AbstractBuild<?, ?> build) {
        ISVNAuthenticationProvider sap;
        try {
            sap = ((SubversionSCM)this.getJenkinsScm()).createAuthenticationProvider(build.getParent(), this.getLocation());
        }
        catch (NoSuchMethodError e) {
            this.buildListener.getLogger().println("[RELEASE] You are using an old subversion jenkins plugin, please consider upgrading.");
            sap = ((SubversionSCM)this.getJenkinsScm()).getDescriptor().createAuthenticationProvider((AbstractProject)build.getParent());
        }
        if (sap == null) {
            throw new AbortException("Subversion authentication info is not set.");
        }
        return sap;
    }

    private static class CleanupCallable
    extends MasterToSlaveFileCallable<Void> {
        private final SubversionSCM.ModuleLocation location;
        private final ISVNAuthenticationProvider authProvider;
        private final TaskListener listener;

        private CleanupCallable(SubversionSCM.ModuleLocation location, ISVNAuthenticationProvider authProvider, TaskListener listener) {
            this.location = location;
            this.authProvider = authProvider;
            this.listener = listener;
        }

        public Void invoke(File ws, VirtualChannel channel) throws IOException, InterruptedException {
            File workingCopy = new File(ws, this.location.getLocalDir()).getCanonicalFile();
            try {
                SubversionManager.log(this.listener, "Cleanup working copy: " + workingCopy);
                ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
                sam.setAuthenticationProvider(this.authProvider);
                SVNWCClient wcClient = new SVNWCClient(sam, null);
                wcClient.doCleanup(workingCopy);
                return null;
            }
            catch (SVNException e) {
                debuggingLogger.log(Level.FINE, "Failed Cleanup ", e);
                throw new IOException(e.getMessage());
            }
        }
    }

    private static class RevertWorkingCopyCallable
    extends MasterToSlaveFileCallable<Void> {
        private final SubversionSCM.ModuleLocation location;
        private final ISVNAuthenticationProvider authProvider;
        private final TaskListener listener;

        public RevertWorkingCopyCallable(SubversionSCM.ModuleLocation location, ISVNAuthenticationProvider authProvider, TaskListener listener) {
            this.location = location;
            this.authProvider = authProvider;
            this.listener = listener;
        }

        public Void invoke(File ws, VirtualChannel channel) throws IOException, InterruptedException {
            File workingCopy = new File(ws, this.location.getLocalDir()).getCanonicalFile();
            try {
                SubversionManager.log(this.listener, "Reverting working copy: " + workingCopy);
                ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
                sam.setAuthenticationProvider(this.authProvider);
                SVNWCClient wcClient = new SVNWCClient(sam, null);
                wcClient.doRevert(new File[]{workingCopy}, SVNDepth.INFINITY, null);
                return null;
            }
            catch (SVNException e) {
                debuggingLogger.log(Level.FINE, "Failed Revert WorkingCopy ", e);
                throw new IOException(e.getMessage());
            }
        }
    }

    private static class SVNCreateTagCallable
    extends MasterToSlaveFileCallable<Void> {
        private final String tagUrl;
        private final String commitMessage;
        private final SubversionSCM.ModuleLocation location;
        private final ISVNAuthenticationProvider authProvider;
        private final TaskListener buildListener;

        public SVNCreateTagCallable(String tagUrl, String commitMessage, SubversionSCM.ModuleLocation location, ISVNAuthenticationProvider provider, TaskListener listener) {
            this.tagUrl = tagUrl;
            this.commitMessage = commitMessage;
            this.location = location;
            this.authProvider = provider;
            this.buildListener = listener;
        }

        public Void invoke(File ws, VirtualChannel channel) throws IOException, InterruptedException {
            File workingCopy = new File(ws, this.location.getLocalDir()).getCanonicalFile();
            try {
                SVNCopyClient copyClient;
                SVNURL svnUrl = SVNURL.parseURIEncoded((String)this.tagUrl);
                try {
                    copyClient = SubversionSCM.createClientManager((ISVNAuthenticationProvider)this.authProvider).getCopyClient();
                }
                catch (NoSuchMethodError e) {
                    this.buildListener.getLogger().println("[RELEASE] You are using an old subversion jenkins plugin, please consider upgrading.");
                    copyClient = SubversionSCM.createSvnClientManager((ISVNAuthenticationProvider)this.authProvider).getCopyClient();
                }
                this.buildListener.getLogger().println("[RELEASE] Creating subversion tag: " + this.tagUrl);
                SVNCopySource source = new SVNCopySource(SVNRevision.WORKING, SVNRevision.WORKING, workingCopy);
                SVNCommitInfo commitInfo = copyClient.doCopy(new SVNCopySource[]{source}, svnUrl, false, true, true, this.commitMessage, new SVNProperties());
                SVNErrorMessage errorMessage = commitInfo.getErrorMessage();
                if (errorMessage != null) {
                    throw new IOException("Failed to create tag: " + errorMessage.getFullMessage());
                }
                return null;
            }
            catch (SVNException e) {
                debuggingLogger.log(Level.FINE, "Failed to create tag", e);
                throw new IOException("Subversion tag creation failed: " + e.getMessage());
            }
        }
    }

    private static class SVNCommitWorkingCopyCallable
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final String commitMessage;
        private final SubversionSCM.ModuleLocation location;
        private final ISVNAuthenticationProvider authProvider;
        private final TaskListener buildListener;

        public SVNCommitWorkingCopyCallable(String commitMessage, SubversionSCM.ModuleLocation location, ISVNAuthenticationProvider provider, TaskListener listener) {
            this.commitMessage = commitMessage;
            this.location = location;
            this.authProvider = provider;
            this.buildListener = listener;
        }

        public Void invoke(File ws, VirtualChannel channel) throws IOException, InterruptedException {
            File workingCopy = new File(ws, this.location.getLocalDir()).getCanonicalFile();
            try {
                ISVNAuthenticationManager sam = SVNWCUtil.createDefaultAuthenticationManager();
                sam.setAuthenticationProvider(this.authProvider);
                SVNCommitClient commitClient = new SVNCommitClient(sam, null);
                this.buildListener.getLogger().println("[RELEASE] " + this.commitMessage);
                debuggingLogger.fine(String.format("Committing working copy: '%s'", workingCopy));
                SVNCommitInfo commitInfo = commitClient.doCommit(new File[]{workingCopy}, true, this.commitMessage, null, null, true, true, SVNDepth.INFINITY);
                SVNErrorMessage errorMessage = commitInfo.getErrorMessage();
                if (errorMessage != null) {
                    throw new IOException("Failed to commit working copy: " + errorMessage.getFullMessage());
                }
                return null;
            }
            catch (SVNException e) {
                debuggingLogger.log(Level.FINE, "Failed to Commit WorkingCopy", e);
                throw new IOException(e.getMessage());
            }
        }
    }
}

