/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm.git;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.UserRemoteConfig;
import hudson.security.ACL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jfrog.hudson.release.ReleaseRepository;
import org.jfrog.hudson.release.scm.AbstractScmManager;
import org.jfrog.hudson.release.scm.git.GitPushDryRunCallable;

public class GitManager
extends AbstractScmManager<GitSCM> {
    private static Logger debuggingLogger = Logger.getLogger(GitManager.class.getName());
    private StandardCredentials credentials;

    public GitManager(AbstractBuild<?, ?> build, TaskListener buildListener) {
        super(build, buildListener);
    }

    public void setGitCredentials(StandardCredentials credentials) {
        this.credentials = credentials;
    }

    public void checkoutBranch(String branch, boolean create) throws IOException, InterruptedException {
        GitClient client = this.getGitClient(null);
        debuggingLogger.fine(String.format("Checkout Branch '%s' with create=%s", branch, create));
        if (create) {
            client.checkout(null, branch);
        } else {
            client.checkout(branch);
        }
    }

    @Override
    public void commitWorkingCopy(String commitMessage) throws IOException, InterruptedException {
        GitClient client = this.getGitClient(null);
        debuggingLogger.fine("Adding all files in the current directory");
        client.add("-u");
        debuggingLogger.fine(String.format("Committing working copy with message '%s'", commitMessage));
        client.commit(commitMessage);
    }

    @Override
    public void createTag(String tagName, String commitMessage) throws IOException, InterruptedException {
        GitClient client = this.getGitClient(null);
        GitManager.log(this.buildListener, String.format("Creating tag '%s' with message '%s'", tagName, commitMessage));
        client.tag(tagName, commitMessage);
    }

    public boolean isTagExists(ReleaseRepository releaseRepository, String tagName) throws IOException, InterruptedException {
        GitClient client = this.getGitClient(releaseRepository);
        GitManager.log(this.buildListener, String.format("Checking if tag '%s' exists.", tagName));
        return client.tagExists(tagName);
    }

    public void testPush(ReleaseRepository releaseRepository, String tagName) throws Exception {
        String repositoryUrl = releaseRepository.getGitUri().toLowerCase();
        if (!repositoryUrl.startsWith("http://") && !repositoryUrl.startsWith("https://")) {
            return;
        }
        this.createTag(tagName, "this is a test tag");
        GitClient client = this.getGitClient(releaseRepository);
        GitManager.log(this.buildListener, String.format("Attempting to push tag %s with --dry-run", tagName));
        List<Pair<String, StandardCredentials>> credentialsList = this.getGitClientCredentials();
        StandardUsernamePasswordCredentials credentials = null;
        for (Pair<String, StandardCredentials> credentialsPair : credentialsList) {
            if (!((String)credentialsPair.getKey()).equals(releaseRepository.getGitUri())) continue;
            credentials = (StandardUsernamePasswordCredentials)credentialsPair.getValue();
            break;
        }
        if (credentials == null) {
            throw new IllegalStateException("Failed to retrieve git credentials");
        }
        FilePath directory = this.getWorkingDirectory((GitSCM)this.getJenkinsScm(), this.build.getWorkspace());
        directory.act((FilePath.FileCallable)new GitPushDryRunCallable(credentials.getUsername(), credentials.getPassword().getPlainText(), releaseRepository.getTargetRepoPrivateUri(), client.getWorkTree().toURI()));
        GitManager.log(this.buildListener, "Push dry-run completed successfully");
    }

    public void push(ReleaseRepository releaseRepository, String branch) throws Exception {
        GitClient client = this.getGitClient(releaseRepository);
        GitManager.log(this.buildListener, String.format("Pushing branch '%s' to '%s'", branch, releaseRepository.getGitUri()));
        client.push().tags(true).to(new URIish(releaseRepository.getTargetRepoPrivateUri())).ref("refs/heads/" + branch).timeout(Integer.valueOf(10)).execute();
    }

    public void revertWorkingCopy() throws IOException, InterruptedException {
        GitClient client = this.getGitClient(null);
        GitManager.log(this.buildListener, "Reverting git working copy (reset --hard)");
        client.clean();
    }

    public void deleteLocalBranch(String branch) throws IOException, InterruptedException {
        GitClient client = this.getGitClient(null);
        GitManager.log(this.buildListener, "Deleting local git branch: " + branch);
        client.deleteBranch(branch);
    }

    public void deleteRemoteBranch(ReleaseRepository releaseRepository, String branch) throws IOException, InterruptedException {
        GitClient client = this.getGitClient(releaseRepository);
        GitManager.log(this.buildListener, String.format("Deleting remote branch '%s' on '%s'", branch, releaseRepository.getGitUri()));
        client.push(releaseRepository.getRepositoryName(), ":refs/heads/" + branch);
    }

    public void deleteLocalTag(String tag) throws IOException, InterruptedException {
        GitClient client = this.getGitClient(null);
        GitManager.log(this.buildListener, "Deleting local tag: " + tag);
        client.deleteTag(tag);
    }

    public void deleteRemoteTag(ReleaseRepository releaseRepository, String tag) throws IOException, InterruptedException {
        GitClient client = this.getGitClient(releaseRepository);
        GitManager.log(this.buildListener, String.format("Deleting remote tag '%s' from '%s'", tag, releaseRepository.getGitUri()));
        client.push(releaseRepository.getRepositoryName(), ":refs/tags/" + tag);
    }

    @Override
    public String getRemoteUrl(String defaultRemoteUrl) {
        if (StringUtils.isBlank((String)defaultRemoteUrl)) {
            RemoteConfig remoteConfig = (RemoteConfig)((GitSCM)this.getJenkinsScm()).getRepositories().get(0);
            URIish uri = (URIish)remoteConfig.getURIs().get(0);
            return uri.toPrivateString();
        }
        return defaultRemoteUrl;
    }

    public String getBranchNameWithoutRemote(String branchName) {
        List repositories = ((GitSCM)this.getJenkinsScm()).getRepositories();
        for (RemoteConfig remoteConfig : repositories) {
            String prefix = remoteConfig.getName() + "/";
            if (!branchName.startsWith(prefix)) continue;
            return StringUtils.removeStart((String)branchName, (String)prefix);
        }
        return branchName;
    }

    public ReleaseRepository getRemoteConfig(String defaultRemoteNameOrUrl) throws IOException {
        List repositories = ((GitSCM)this.getJenkinsScm()).getRepositories();
        if (StringUtils.isBlank((String)defaultRemoteNameOrUrl)) {
            if (repositories == null || repositories.isEmpty()) {
                throw new GitException("Git remote config repositories are null or empty.");
            }
            return new ReleaseRepository((URIish)((RemoteConfig)repositories.get(0)).getURIs().get(0), ((RemoteConfig)repositories.get(0)).getName());
        }
        for (RemoteConfig remoteConfig : repositories) {
            if (!remoteConfig.getName().equals(defaultRemoteNameOrUrl)) continue;
            return new ReleaseRepository((URIish)remoteConfig.getURIs().get(0), remoteConfig.getName());
        }
        if (this.checkGitValidUri(defaultRemoteNameOrUrl)) {
            return new ReleaseRepository(defaultRemoteNameOrUrl, "externalGitUrl");
        }
        throw new IOException("Target Remote Name: " + defaultRemoteNameOrUrl + " ,doesn`t exist");
    }

    private boolean checkGitValidUri(String defaultRemoteNameOrUrl) {
        String regex = "(\\w+://)(.+@)*([\\w\\d\\.]+)(:[\\d]+){0,1}/*(.*)|(.+@)*([\\w\\d\\.]+):(.*)|file://(.*)";
        return Pattern.compile(regex).matcher(defaultRemoteNameOrUrl).matches();
    }

    private GitClient getGitClient(ReleaseRepository releaseRepository) throws IOException, InterruptedException {
        FilePath directory = this.getWorkingDirectory((GitSCM)this.getJenkinsScm(), this.build.getWorkspace());
        EnvVars env = this.build.getEnvironment(this.buildListener);
        Git git = new Git(this.buildListener, env);
        git.in(directory);
        git.using(((GitSCM)this.getJenkinsScm()).getGitExe(this.build.getBuiltOn(), this.buildListener));
        GitClient client = git.getClient();
        client.setCommitter(StringUtils.defaultIfEmpty((String)((String)env.get((Object)"GIT_COMMITTER_NAME")), (String)""), StringUtils.defaultIfEmpty((String)((String)env.get((Object)"GIT_COMMITTER_EMAIL")), (String)""));
        client.setAuthor(StringUtils.defaultIfEmpty((String)((String)env.get((Object)"GIT_AUTHOR_NAME")), (String)""), StringUtils.defaultIfEmpty((String)((String)env.get((Object)"GIT_AUTHOR_EMAIL")), (String)""));
        if (releaseRepository != null && releaseRepository.isTargetRepoUri()) {
            client.setRemoteUrl(releaseRepository.getRepositoryName(), releaseRepository.getTargetRepoPrivateUri());
        } else {
            this.addRemoteRepoToConfig(client);
        }
        this.addCredentialsToGitClient(client);
        return client;
    }

    private String getFirstGitURI(RemoteConfig remoteRepository) {
        List urIs = remoteRepository.getURIs();
        if (urIs == null || urIs.isEmpty()) {
            throw new GitException("Error performing push tag command, repository URIs are null or empty.");
        }
        return ((URIish)urIs.get(0)).toString();
    }

    private void addRemoteRepoToConfig(GitClient client) throws InterruptedException {
        GitSCM gitScm = (GitSCM)this.getJenkinsScm();
        for (RemoteConfig uc : gitScm.getRepositories()) {
            if (client.getRemoteUrl(uc.getName()) != null) continue;
            client.setRemoteUrl(uc.getName(), ((URIish)uc.getURIs().get(0)).toPrivateASCIIString());
        }
    }

    private void addCredentialsToGitClient(GitClient client) {
        List<Pair<String, StandardCredentials>> credentialsList = this.getGitClientCredentials();
        for (Pair<String, StandardCredentials> entry : credentialsList) {
            client.addCredentials((String)entry.getKey(), (StandardCredentials)entry.getValue());
        }
    }

    private List<Pair<String, StandardCredentials>> getGitClientCredentials() {
        ArrayList<Pair<String, StandardCredentials>> credentialsList = new ArrayList<Pair<String, StandardCredentials>>();
        GitSCM gitScm = (GitSCM)this.getJenkinsScm();
        for (UserRemoteConfig uc : gitScm.getUserRemoteConfigs()) {
            StandardUsernameCredentials credentials;
            String url = uc.getUrl();
            if (this.credentials != null) {
                credentialsList.add((Pair<String, StandardCredentials>)Pair.of((Object)url, (Object)this.credentials));
                continue;
            }
            if (uc.getCredentialsId() == null || (credentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)this.build.getProject(), (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)url).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)uc.getCredentialsId()), GitClient.CREDENTIALS_MATCHER}))) == null) continue;
            credentialsList.add((Pair<String, StandardCredentials>)Pair.of((Object)url, (Object)credentials));
        }
        return credentialsList;
    }

    private FilePath getWorkingDirectory(GitSCM gitSCM, FilePath ws) throws IOException {
        String relativeTargetDir = gitSCM.getRelativeTargetDir() == null ? "" : gitSCM.getRelativeTargetDir();
        return new FilePath(ws, relativeTargetDir);
    }
}

