/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.gradle;

import com.google.common.collect.Maps;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.plugins.gradle.Gradle;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.gradle.ArtifactoryGradleConfigurator;
import org.jfrog.hudson.release.PromotionConfig;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.VcsConfig;
import org.jfrog.hudson.release.VersionedModule;
import org.jfrog.hudson.release.gradle.GradleReleaseWrapper;
import org.jfrog.hudson.util.PropertyUtils;
import org.kohsuke.stapler.StaplerRequest;

public abstract class BaseGradleReleaseAction
extends ReleaseAction<AbstractProject<?, ?>, ArtifactoryGradleConfigurator> {
    private transient Map<String, String> releaseProps;
    private transient Map<String, String> nextIntegProps;
    private Map<String, String> releaseVersionPerModule;
    private Map<String, String> nextVersionPerModule;

    public BaseGradleReleaseAction(AbstractProject<?, ?> project) {
        super(project, ArtifactoryGradleConfigurator.class);
    }

    public String[] getReleaseProperties() {
        return this.getReleaseWrapper().getReleasePropsKeysList();
    }

    public String[] getNextIntegProperties() {
        return this.getReleaseWrapper().getNextIntegPropsKeysList();
    }

    @Override
    protected void initBuilderSpecific() throws Exception {
        this.reset();
        FilePath workspace = this.getModuleRoot(EnvVars.masterEnvVars);
        FilePath gradlePropertiesPath = new FilePath(workspace, "gradle.properties");
        if (this.releaseProps == null) {
            this.releaseProps = PropertyUtils.getModulesPropertiesFromPropFile(gradlePropertiesPath, this.getReleaseProperties());
        }
        if (this.nextIntegProps == null) {
            this.nextIntegProps = PropertyUtils.getModulesPropertiesFromPropFile(gradlePropertiesPath, this.getNextIntegProperties());
        }
    }

    public FilePath getModuleRoot(Map<String, String> globalEnv) throws IOException, InterruptedException {
        FilePath someWorkspace = this.project.getSomeWorkspace();
        if (someWorkspace == null) {
            throw new IllegalStateException("Couldn't find workspace");
        }
        HashMap workspaceEnv = Maps.newHashMap();
        workspaceEnv.put("WORKSPACE", someWorkspace.getRemote());
        for (Builder builder : this.getBuilders()) {
            if (!(builder instanceof Gradle)) continue;
            Gradle gradleBuilder = (Gradle)builder;
            String rootBuildScriptDir = gradleBuilder.getRootBuildScriptDir();
            if (rootBuildScriptDir != null && rootBuildScriptDir.trim().length() != 0) {
                String rootBuildScriptNormalized = Util.replaceMacro((String)rootBuildScriptDir.trim(), (Map)workspaceEnv);
                rootBuildScriptNormalized = Util.replaceMacro((String)rootBuildScriptNormalized, globalEnv);
                return new FilePath(someWorkspace, rootBuildScriptNormalized);
            }
            return someWorkspace;
        }
        throw new IllegalArgumentException("Couldn't find Gradle builder in the current builders list");
    }

    public void reset() {
        this.releaseProps = null;
        this.nextIntegProps = null;
        this.releaseVersion = null;
    }

    @Override
    public List<String> getRepositoryKeys() throws IOException {
        ArtifactoryServer server = this.getArtifactoryServer();
        if (server != null) {
            return this.getArtifactoryServer().getReleaseRepositoryKeysFirst((DeployerOverrider)this.getWrapper(), (Item)this.project);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isArtifactoryPro() {
        return this.getArtifactoryServer().isArtifactoryPro((DeployerOverrider)this.getWrapper(), (Item)this.project);
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        ArtifactoryGradleConfigurator configurator = (ArtifactoryGradleConfigurator)this.getWrapper();
        if (configurator != null) {
            return configurator.getArtifactoryServer();
        }
        return null;
    }

    @Override
    public String getTargetRemoteName() {
        return this.getReleaseWrapper().getTargetRemoteName();
    }

    @Override
    public String latestVersioningSelection() {
        return ReleaseAction.VERSIONING.PER_MODULE.name();
    }

    public String getValueForProp(String prop) {
        return this.nextIntegProps.get(prop);
    }

    @Override
    public String calculateReleaseVersion(String fromVersion) {
        String version = this.releaseProps.get(fromVersion);
        if (StringUtils.isBlank((String)version)) {
            version = this.nextIntegProps.get(fromVersion);
        }
        if (StringUtils.isNotBlank((String)version)) {
            return super.calculateReleaseVersion(version);
        }
        return "";
    }

    public String getCurrentVersionFor(String moduleName) {
        return this.releaseProps.get(moduleName);
    }

    @Override
    public String getReleaseVersionFor(Object moduleName) {
        switch (this.versioning) {
            case GLOBAL: {
                return this.releaseVersion;
            }
            case PER_MODULE: {
                return this.releaseVersionPerModule.get(moduleName.toString());
            }
        }
        return null;
    }

    @Override
    public String getNextVersionFor(Object moduleName) {
        switch (this.versioning) {
            case GLOBAL: {
                return this.nextVersion;
            }
            case PER_MODULE: {
                return this.nextVersionPerModule.get(moduleName.toString());
            }
        }
        return null;
    }

    @Override
    protected PluginSettings getSelectedStagingPlugin() throws Exception {
        return ((ArtifactoryGradleConfigurator)this.getWrapper()).getSelectedStagingPlugin();
    }

    @Override
    protected String getSelectedStagingPluginName() {
        return ((ArtifactoryGradleConfigurator)this.getWrapper()).getDeployerDetails().getUserPluginKey();
    }

    @Override
    protected void doPerModuleVersioning(StaplerRequest req) {
        this.releaseVersionPerModule = Maps.newHashMap();
        this.nextVersionPerModule = Maps.newHashMap();
        Enumeration params = req.getParameterNames();
        while (params.hasMoreElements()) {
            String key = (String)params.nextElement();
            if (key.startsWith("release.")) {
                this.releaseVersionPerModule.put(StringUtils.removeStart((String)key, (String)"release."), req.getParameter(key));
                continue;
            }
            if (!key.startsWith("next.")) continue;
            this.nextVersionPerModule.put(StringUtils.removeStart((String)key, (String)"next."), req.getParameter(key));
        }
    }

    @Override
    protected void doPerModuleVersioning(Map<String, VersionedModule> defaultModules) {
        this.releaseVersionPerModule = Maps.newHashMap();
        this.nextVersionPerModule = Maps.newHashMap();
        for (Map.Entry<String, VersionedModule> entry : defaultModules.entrySet()) {
            VersionedModule versionedModule = entry.getValue();
            String module = versionedModule.getModuleName();
            this.releaseVersionPerModule.put(module, versionedModule.getReleaseVersion());
            this.nextVersionPerModule.put(module, versionedModule.getNextDevelopmentVersion());
        }
    }

    @Override
    protected void prepareBuilderSpecificDefaultGlobalModule() {
    }

    @Override
    protected void prepareBuilderSpecificDefaultVersioning() {
        this.defaultVersioning = ReleaseAction.VERSIONING.PER_MODULE.toString();
    }

    @Override
    protected void prepareBuilderSpecificDefaultModules() {
        this.defaultModules = Maps.newHashMap();
        for (String releaseProperties : this.getReleaseProperties()) {
            this.defaultModules.put(releaseProperties, new VersionedModule(releaseProperties, this.calculateReleaseVersion(releaseProperties), null));
        }
        for (String nextIntegProperty : this.getNextIntegProperties()) {
            this.defaultModules.put(nextIntegProperty, new VersionedModule(nextIntegProperty, this.calculateReleaseVersion(nextIntegProperty), this.calculateNextVersion(nextIntegProperty)));
        }
    }

    @Override
    protected void prepareBuilderSpecificDefaultVcsConfig() {
        String defaultReleaseBranch = this.getDefaultReleaseBranch();
        String defaultTagUrl = this.getDefaultTagUrl();
        this.defaultVcsConfig = new VcsConfig(StringUtils.isNotBlank((String)defaultReleaseBranch) && this.getReleaseWrapper().isUseReleaseBranch(), defaultReleaseBranch, StringUtils.isNotBlank((String)defaultTagUrl), defaultTagUrl, this.getDefaultTagComment(), this.getDefaultNextDevelCommitMessage());
    }

    @Override
    protected void prepareBuilderSpecificDefaultPromotionConfig() throws IOException {
        this.defaultPromotionConfig = new PromotionConfig(this.getDefaultReleaseStagingRepository(), null);
    }

    private GradleReleaseWrapper getReleaseWrapper() {
        return ((ArtifactoryGradleConfigurator)this.getWrapper()).getReleaseWrapper();
    }

    private String getDefaultReleaseBranch() {
        String releaseBranchPrefix = this.getReleaseWrapper().getReleaseBranchPrefix();
        return StringUtils.trimToEmpty((String)releaseBranchPrefix) + this.getFirstReleaseVersion();
    }

    private String getDefaultTagUrl() {
        String baseTagUrl = this.getReleaseWrapper().getTagPrefix();
        return this.getBaseTagUrlAccordingToScm(baseTagUrl) + this.getFirstReleaseVersion();
    }

    private String getDefaultTagComment() {
        return "[artifactory-release] " + "Release version " + this.getFirstReleaseVersion();
    }

    private String getFirstReleaseVersion() {
        return super.calculateReleaseVersion(this.getCurrentVersion());
    }

    private String getCurrentVersion() {
        String version = this.extractNumericVersion(this.releaseProps.values());
        if (StringUtils.isBlank((String)version)) {
            version = this.extractNumericVersion(this.nextIntegProps.values());
        }
        if (StringUtils.isBlank((String)version)) {
            if (!this.releaseProps.values().isEmpty()) {
                version = this.releaseProps.values().iterator().next();
            } else if (!this.nextIntegProps.values().isEmpty()) {
                version = this.nextIntegProps.values().iterator().next();
            }
        }
        return version;
    }

    private String extractNumericVersion(Collection<String> versionStrings) {
        if (versionStrings == null) {
            return "";
        }
        for (String value : versionStrings) {
            String releaseValue = this.calculateReleaseVersion(value);
            if (releaseValue.equals(value)) continue;
            return releaseValue;
        }
        return "";
    }

    private String getDefaultReleaseStagingRepository() throws IOException {
        String defaultStagingRepo = this.getReleaseWrapper().getDefaultReleaseStagingRepository();
        if (defaultStagingRepo != null && this.getRepositoryKeys().contains(defaultStagingRepo)) {
            return defaultStagingRepo;
        }
        ArtifactoryGradleConfigurator publisher = (ArtifactoryGradleConfigurator)this.getWrapper();
        if (publisher == null) {
            return null;
        }
        return publisher.getRepositoryKey();
    }
}

