/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Maps;
import hudson.Util;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.tasks.BuildWrapper;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.ArtifactoryPlugin;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.PluginSettings;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.release.PromotionConfig;
import org.jfrog.hudson.release.VcsConfig;
import org.jfrog.hudson.release.VersionedModule;
import org.jfrog.hudson.release.scm.AbstractScmCoordinator;
import org.jfrog.hudson.util.ErrorResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class ReleaseAction<P extends AbstractProject, W extends BuildWrapper>
implements Action {
    private static final Logger log = Logger.getLogger(ReleaseAction.class.getName());
    public static final String RT_RELEASE_STAGING = "RT_RELEASE_STAGING_";
    protected final transient P project;
    protected VERSIONING versioning;
    protected String releaseVersion;
    protected String nextVersion;
    protected transient boolean strategyRequestFailed = false;
    protected transient String strategyRequestErrorMessage = null;
    protected transient boolean strategyPluginExists;
    protected transient Map stagingStrategy;
    protected transient String defaultVersioning;
    protected transient VersionedModule defaultGlobalModule;
    protected transient Map<String, VersionedModule> defaultModules;
    protected transient VcsConfig defaultVcsConfig;
    protected transient PromotionConfig defaultPromotionConfig;
    Boolean pro;
    boolean createVcsTag;
    String tagUrl;
    String tagComment;
    String nextDevelCommitComment;
    String stagingRepositoryKey;
    String stagingComment;
    boolean createReleaseBranch;
    String releaseBranch;
    private Class<W> wrapperClass;
    boolean overrideCredentials;
    String username;
    String password;

    public ReleaseAction(P project, Class<W> wrapperClass) {
        this.project = project;
        this.wrapperClass = wrapperClass;
    }

    public void init() throws Exception {
        this.initBuilderSpecific();
        this.resetFields();
        if (!"None".equals(this.getSelectedStagingPluginName())) {
            PluginSettings selectedStagingPluginSettings = this.getSelectedStagingPlugin();
            try {
                this.stagingStrategy = this.getArtifactoryServer().getStagingStrategy(selectedStagingPluginSettings, Util.rawEncode((String)this.project.getName()), (Item)this.project);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to obtain staging strategy: " + e.getMessage(), e);
                this.strategyRequestFailed = true;
                this.strategyRequestErrorMessage = "Failed to obtain staging strategy '" + selectedStagingPluginSettings.getPluginName() + "': " + e.getMessage() + ".\nPlease review the log for further information.";
                this.stagingStrategy = null;
            }
            this.strategyPluginExists = this.stagingStrategy != null && !this.stagingStrategy.isEmpty();
        }
        this.prepareDefaultVersioning();
        this.prepareDefaultGlobalModule();
        this.prepareDefaultModules();
        this.prepareDefaultVcsSettings();
        this.prepareDefaultPromotionConfig();
    }

    private void resetFields() {
        this.strategyRequestFailed = false;
        this.strategyRequestErrorMessage = null;
        this.strategyPluginExists = false;
        this.stagingStrategy = null;
        this.defaultVersioning = null;
        this.defaultGlobalModule = null;
        this.defaultModules = null;
        this.defaultVcsConfig = null;
        this.defaultPromotionConfig = null;
    }

    public boolean isStrategyRequestFailed() {
        return this.strategyRequestFailed;
    }

    public String getStrategyRequestErrorMessage() {
        return this.strategyRequestErrorMessage;
    }

    public abstract String getTargetRemoteName();

    public String getTitle() {
        StringBuilder titleBuilder = new StringBuilder("Artifactory Pro Release Staging");
        String pluginName = this.getSelectedStagingPluginName();
        if (this.strategyPluginExists && StringUtils.isNotBlank((String)pluginName)) {
            titleBuilder.append(" - Using the '").append(pluginName).append("' staging plugin.");
        }
        return titleBuilder.toString();
    }

    public String getDisplayName() {
        return "Artifactory Release Staging";
    }

    public String getUrlName() {
        return "release";
    }

    public VERSIONING getVersioning() {
        return this.versioning;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getNextVersion() {
        return this.nextVersion;
    }

    public boolean isCreateVcsTag() {
        return this.createVcsTag;
    }

    public String getTagUrl() {
        return this.tagUrl;
    }

    public String getTagComment() {
        return StringUtils.isNotBlank((String)this.tagComment) ? this.tagComment : this.getDefaultVcsConfig().getTagComment();
    }

    public boolean isOverrideCredentials() {
        return this.overrideCredentials;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNextDevelCommitComment() {
        return this.nextDevelCommitComment;
    }

    public boolean isCreateReleaseBranch() {
        return this.createReleaseBranch;
    }

    public String getReleaseBranch() {
        return this.releaseBranch;
    }

    public String getStagingComment() {
        return this.stagingComment;
    }

    public String getStagingRepositoryKey() {
        return this.stagingRepositoryKey;
    }

    public String latestVersioningSelection() {
        return VERSIONING.GLOBAL.name();
    }

    public String getDefaultGlobalReleaseVersion() {
        return this.defaultGlobalModule != null ? this.defaultGlobalModule.getReleaseVersion() : null;
    }

    public String getDefaultGlobalNextDevelopmentVersion() {
        return this.defaultGlobalModule != null ? this.defaultGlobalModule.getNextDevelopmentVersion() : null;
    }

    public Collection<VersionedModule> getDefaultModules() {
        return this.defaultModules.values();
    }

    public boolean isGit() {
        return AbstractScmCoordinator.isGitScm(this.project);
    }

    public VcsConfig getDefaultVcsConfig() {
        return this.defaultVcsConfig;
    }

    public PromotionConfig getDefaultPromotionConfig() {
        return this.defaultPromotionConfig;
    }

    public abstract List<String> getRepositoryKeys() throws IOException;

    public abstract boolean isArtifactoryPro();

    public abstract ArtifactoryServer getArtifactoryServer();

    protected void doApi(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        try {
            log.log(Level.INFO, "Initiating Artifactory Release Staging using API");
            this.project.checkPermission(ArtifactoryPlugin.RELEASE);
            this.init();
            this.readStagingPluginValues();
            this.overrideStagingPluginParams(req);
            Queue.WaitingItem item = Jenkins.getInstance().getQueue().schedule(this.project, 0, new Action[]{this, new CauseAction((Cause)new Cause.UserIdCause())});
            if (item == null) {
                log.log(Level.SEVERE, "Failed to schedule a release build following a Release API invocation");
                resp.setStatus(500);
            } else {
                String url = req.getContextPath() + '/' + item.getUrl();
                JSONObject json = new JSONObject();
                json.element("queueItem", item.getId());
                json.element("releaseVersion", (Object)this.getReleaseVersion());
                json.element("nextVersion", (Object)this.getNextVersion());
                json.element("releaseBranch", (Object)this.getReleaseBranch());
                resp.getOutputStream().print(json.toString());
                resp.sendRedirect(201, url);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Artifactory Release Staging API invocation failed: " + e.getMessage(), e);
            resp.setStatus(500);
            ErrorResponse errorResponse = new ErrorResponse(500, e.getMessage());
            ObjectMapper mapper = new ObjectMapper();
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            resp.getWriter().write(mapper.writeValueAsString((Object)errorResponse));
        }
    }

    @RequirePOST
    public void doSubmit(StaplerRequest req, StaplerResponse resp) throws IOException, ServletException {
        this.project.checkPermission(ArtifactoryPlugin.RELEASE);
        this.readRequestParams(req, false);
        if (this.project.scheduleBuild(0, (Cause)new Cause.UserIdCause(), new Action[]{this})) {
            resp.sendRedirect(this.project.getAbsoluteUrl());
        }
    }

    private void overrideStagingPluginParams(StaplerRequest req) throws Exception {
        req.bindParameters((Object)this);
        String versioningStr = req.getParameter("versioning");
        if (versioningStr != null) {
            this.versioning = VERSIONING.valueOf(versioningStr);
            switch (this.versioning) {
                case GLOBAL: {
                    this.doGlobalVersioning(req);
                    break;
                }
                case PER_MODULE: {
                    this.doPerModuleVersioning(req);
                }
            }
        }
        if (req.getParameter("createVcsTag") != null) {
            this.createVcsTag = Boolean.valueOf(req.getParameter("createVcsTag"));
        }
        if (req.getParameter("tagUrl") != null) {
            this.tagUrl = req.getParameter("tagUrl");
        }
        if (req.getParameter("tagComment") != null) {
            this.tagComment = req.getParameter("tagComment");
        }
        if (req.getParameter("createReleaseBranch") != null) {
            this.createReleaseBranch = Boolean.valueOf(req.getParameter("createReleaseBranch"));
        }
        if (req.getParameter("releaseBranch") != null) {
            this.releaseBranch = req.getParameter("releaseBranch");
        }
        if (req.getParameter("nextDevelCommitComment") != null) {
            this.nextDevelCommitComment = req.getParameter("nextDevelCommitComment");
        }
        if (req.getParameter("repositoryKey") != null) {
            this.stagingRepositoryKey = req.getParameter("repositoryKey");
        }
        if (req.getParameter("stagingComment") != null) {
            this.stagingComment = req.getParameter("stagingComment");
        }
        if (req.getParameter("overrideCredentials") != null) {
            this.overrideCredentials = Boolean.valueOf(req.getParameter("overrideCredentials"));
        }
        if (req.getParameter("username") != null) {
            this.username = req.getParameter("username");
        }
        if (req.getParameter("password") != null) {
            this.password = req.getParameter("password");
        }
    }

    private void readRequestParams(StaplerRequest req, boolean api) {
        req.bindParameters((Object)this);
        String versioningStr = req.getParameter("versioning");
        this.versioning = VERSIONING.valueOf(versioningStr);
        switch (this.versioning) {
            case GLOBAL: {
                this.doGlobalVersioning(req);
                break;
            }
            case PER_MODULE: {
                this.doPerModuleVersioning(req);
            }
        }
        boolean bl = this.createVcsTag = req.getParameter("createVcsTag") != null;
        if (this.createVcsTag) {
            this.tagUrl = req.getParameter("tagUrl");
            this.tagComment = req.getParameter("tagComment");
        }
        boolean bl2 = this.overrideCredentials = req.getParameter("overrideCredentials") != null;
        if (this.overrideCredentials) {
            this.username = req.getParameter("username");
            this.password = req.getParameter("password");
        }
        this.nextDevelCommitComment = req.getParameter("nextDevelCommitComment");
        boolean bl3 = this.createReleaseBranch = req.getParameter("createReleaseBranch") != null;
        if (this.createReleaseBranch) {
            this.releaseBranch = req.getParameter("releaseBranch");
        }
        this.stagingRepositoryKey = req.getParameter("repositoryKey");
        this.stagingComment = req.getParameter("stagingComment");
    }

    public abstract String getReleaseVersionFor(Object var1);

    public abstract String getNextVersionFor(Object var1);

    protected void initBuilderSpecific() throws Exception {
    }

    protected String getDefaultNextDevelCommitMessage() {
        return "[artifactory-release] Next development version";
    }

    protected String getBaseTagUrlAccordingToScm(String baseTagUrl) {
        if (AbstractScmCoordinator.isSvn(this.project) && !baseTagUrl.endsWith("/")) {
            return baseTagUrl + "/";
        }
        return baseTagUrl;
    }

    protected void doGlobalVersioning(StaplerRequest req) {
        if (req.getParameter("releaseVersion") != null) {
            this.releaseVersion = req.getParameter("releaseVersion");
        }
        if (req.getParameter("nextVersion") != null) {
            this.nextVersion = req.getParameter("nextVersion");
        }
    }

    protected void doGlobalVersioning() {
        if (this.defaultGlobalModule != null) {
            this.releaseVersion = this.defaultGlobalModule.getReleaseVersion();
            this.nextVersion = this.defaultGlobalModule.getNextDevelopmentVersion();
        }
    }

    protected W getWrapper() {
        return ActionableHelper.getBuildWrapper(this.project, this.wrapperClass);
    }

    protected String calculateReleaseVersion(String fromVersion) {
        return fromVersion.replace("-SNAPSHOT", "");
    }

    protected String calculateNextVersion(String fromVersion) {
        String nextVersion;
        fromVersion = this.calculateReleaseVersion(fromVersion);
        int lastDotIndex = fromVersion.lastIndexOf(46);
        try {
            if (lastDotIndex != -1) {
                String nextMinorVersion;
                String minorVersionToken = fromVersion.substring(lastDotIndex + 1);
                int lastDashIndex = minorVersionToken.lastIndexOf(45);
                if (lastDashIndex != -1) {
                    String buildNumber = minorVersionToken.substring(lastDashIndex + 1);
                    int nextBuildNumber = Integer.parseInt(buildNumber) + 1;
                    nextMinorVersion = minorVersionToken.substring(0, lastDashIndex + 1) + nextBuildNumber;
                } else {
                    nextMinorVersion = Integer.parseInt(minorVersionToken) + 1 + "";
                }
                nextVersion = fromVersion.substring(0, lastDotIndex + 1) + nextMinorVersion;
            } else {
                int nextMajorVersion = Integer.parseInt(fromVersion) + 1;
                nextVersion = nextMajorVersion + "";
            }
        }
        catch (NumberFormatException e) {
            return fromVersion;
        }
        return nextVersion + "-SNAPSHOT";
    }

    protected abstract void doPerModuleVersioning(StaplerRequest var1);

    protected abstract void doPerModuleVersioning(Map<String, VersionedModule> var1);

    protected abstract PluginSettings getSelectedStagingPlugin() throws Exception;

    protected abstract String getSelectedStagingPluginName();

    protected abstract void prepareBuilderSpecificDefaultGlobalModule();

    protected abstract void prepareBuilderSpecificDefaultModules();

    protected abstract void prepareBuilderSpecificDefaultVcsConfig();

    protected abstract void prepareBuilderSpecificDefaultPromotionConfig() throws IOException;

    protected void prepareBuilderSpecificDefaultVersioning() {
    }

    private void readStagingPluginValues() {
        this.versioning = VERSIONING.valueOf(this.defaultVersioning);
        this.createVcsTag = this.defaultVcsConfig.isCreateTag();
        this.overrideCredentials = this.defaultVcsConfig.isOverrideCredentials();
        this.username = this.defaultVcsConfig.getUsername();
        this.password = this.defaultVcsConfig.getPassword();
        this.tagUrl = this.defaultVcsConfig.getTagUrlOrName();
        this.tagComment = this.defaultVcsConfig.getTagComment();
        this.nextDevelCommitComment = this.defaultVcsConfig.getNextDevelopmentVersionComment();
        this.createReleaseBranch = this.defaultVcsConfig.isUseReleaseBranch();
        this.releaseBranch = this.defaultVcsConfig.getReleaseBranchName();
        this.stagingRepositoryKey = this.defaultPromotionConfig.getTargetRepository();
        this.stagingComment = this.defaultPromotionConfig.getComment();
        switch (this.versioning) {
            case GLOBAL: {
                this.doGlobalVersioning();
                break;
            }
            case PER_MODULE: {
                this.doPerModuleVersioning(this.defaultModules);
            }
        }
    }

    private void prepareDefaultVersioning() {
        if (this.strategyPluginExists) {
            if (this.stagingStrategy.containsKey("defaultModuleVersion")) {
                this.defaultVersioning = VERSIONING.GLOBAL.name();
            } else if (this.stagingStrategy.containsKey("moduleVersionsMap")) {
                this.defaultVersioning = VERSIONING.PER_MODULE.name();
            }
        }
        if (StringUtils.isBlank((String)this.defaultVersioning)) {
            this.prepareBuilderSpecificDefaultVersioning();
        }
    }

    private void prepareDefaultGlobalModule() {
        if (this.strategyPluginExists && this.stagingStrategy.containsKey("defaultModuleVersion")) {
            Map defaultModuleVersion = (Map)this.stagingStrategy.get("defaultModuleVersion");
            this.defaultGlobalModule = new VersionedModule((String)defaultModuleVersion.get("moduleId"), (String)defaultModuleVersion.get("nextRelease"), (String)defaultModuleVersion.get("nextDevelopment"));
        }
        if (this.defaultGlobalModule == null) {
            this.prepareBuilderSpecificDefaultGlobalModule();
        }
    }

    private void prepareDefaultModules() {
        if (this.strategyPluginExists && this.stagingStrategy.containsKey("moduleVersionsMap")) {
            Map moduleVersionsMap = (Map)this.stagingStrategy.get("moduleVersionsMap");
            this.defaultModules = Maps.newHashMap();
            if (!moduleVersionsMap.isEmpty()) {
                for (Map moduleVersion : moduleVersionsMap.values()) {
                    String moduleId = (String)moduleVersion.get("moduleId");
                    this.defaultModules.put(moduleId, new VersionedModule(moduleId, (String)moduleVersion.get("nextRelease"), (String)moduleVersion.get("nextDevelopment")));
                }
            }
        }
        if (this.defaultModules == null) {
            this.prepareBuilderSpecificDefaultModules();
        }
    }

    private void prepareDefaultVcsSettings() {
        if (this.strategyPluginExists && this.stagingStrategy.containsKey("vcsConfig")) {
            Map vcsConfig = (Map)this.stagingStrategy.get("vcsConfig");
            this.defaultVcsConfig = new VcsConfig((Boolean)vcsConfig.get("useReleaseBranch"), this.getStagingConfigAsString(vcsConfig, "releaseBranchName"), (Boolean)vcsConfig.get("createTag"), this.getStagingConfigAsString(vcsConfig, "tagUrlOrName"), this.getStagingConfigAsString(vcsConfig, "tagComment"), this.getStagingConfigAsString(vcsConfig, "nextDevelopmentVersionComment"));
        }
        if (this.defaultVcsConfig == null) {
            this.prepareBuilderSpecificDefaultVcsConfig();
        }
    }

    private void prepareDefaultPromotionConfig() throws IOException {
        if (this.strategyPluginExists && this.stagingStrategy.containsKey("promotionConfig")) {
            Map promotionConfig = (Map)this.stagingStrategy.get("promotionConfig");
            this.defaultPromotionConfig = new PromotionConfig((String)promotionConfig.get("targetRepository"), (String)promotionConfig.get("comment"));
        }
        if (this.defaultPromotionConfig == null) {
            this.prepareBuilderSpecificDefaultPromotionConfig();
        }
    }

    private String getStagingConfigAsString(Map<String, Object> configMap, String key) {
        if (configMap.containsKey(key)) {
            return configMap.get(key).toString();
        }
        return null;
    }

    protected List<Builder> getBuilders() {
        if (this.project instanceof MatrixProject) {
            return ((MatrixProject)this.project).getBuilders();
        }
        if (this.project instanceof MatrixConfiguration) {
            return ((MatrixConfiguration)this.project).getBuilders();
        }
        return ((FreeStyleProject)this.project).getBuilders();
    }

    public StandardCredentials getGitCredentials() {
        if (this.overrideCredentials) {
            return new UsernamePasswordCredentialsImpl(null, null, "release staging Git credentials", this.username, this.password);
        }
        return null;
    }

    public void addVars(Map<String, String> env) {
        if (this.tagUrl != null) {
            env.put("RELEASE_SCM_TAG", this.tagUrl);
            env.put("RT_RELEASE_STAGING_SCM_TAG", this.tagUrl);
        }
        if (this.releaseBranch != null) {
            env.put("RELEASE_SCM_BRANCH", this.releaseBranch);
            env.put("RT_RELEASE_STAGING_SCM_BRANCH", this.releaseBranch);
        }
        if (this.releaseVersion != null) {
            env.put("RT_RELEASE_STAGING_VERSION", this.releaseVersion);
        }
        if (this.nextVersion != null) {
            env.put("RT_RELEASE_STAGING_NEXT_VERSION", this.nextVersion);
        }
    }

    public static enum VERSIONING {
        GLOBAL("One version for all modules"),
        PER_MODULE("Version per module"),
        NONE("Use existing module versions");

        private final String displayMessage;

        private VERSIONING(String displayMessage) {
            this.displayMessage = displayMessage;
        }

        public String getDisplayMessage() {
            return this.displayMessage;
        }
    }
}

