/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps.conan;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.util.CredentialManager;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddUserStep
extends AbstractStepImpl {
    private org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server;
    private String serverName;
    private String conanHome;

    @DataBoundConstructor
    public AddUserStep(org.jfrog.hudson.pipeline.common.types.ArtifactoryServer server, String serverName, String conanHome) {
        this.server = server;
        this.serverName = serverName;
        this.conanHome = conanHome;
    }

    public org.jfrog.hudson.pipeline.common.types.ArtifactoryServer getServer() {
        return this.server;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getConanHome() {
        return this.conanHome;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "conanAddUser";
        }

        public String getDisplayName() {
            return "Add new user to Conan config";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @Inject(optional=true)
        private transient AddUserStep step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;

        protected Boolean run() throws Exception {
            ArgumentListBuilder args = new ArgumentListBuilder();
            ArtifactoryServer artifactoryServer = Utils.prepareArtifactoryServer(null, this.step.getServer());
            ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(artifactoryServer);
            CredentialsConfig deployerConfig = CredentialManager.getPreferredDeployer(configurator, artifactoryServer);
            String username = deployerConfig.provideUsername((Item)this.build.getParent());
            String serverName = this.step.getServerName();
            args.addTokenized("conan user");
            args.add(username);
            args.add("-p");
            args.addMasked(deployerConfig.providePassword((Item)this.build.getParent()));
            args.add("-r");
            args.add(serverName);
            EnvVars extendedEnv = new EnvVars(this.env);
            extendedEnv.put("CONAN_USER_HOME", this.step.getConanHome());
            this.listener.getLogger().println("Adding conan user '" + username + "', server '" + serverName + "'");
            Utils.exeConan(args, this.ws, this.launcher, this.listener, this.build, extendedEnv);
            return true;
        }
    }
}

