/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.executors.PublishBuildInfoExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.kohsuke.stapler.DataBoundConstructor;

public class PublishBuildInfoStep
extends AbstractStepImpl {
    private BuildInfo buildInfo;
    private ArtifactoryServer server;

    @DataBoundConstructor
    public PublishBuildInfoStep(BuildInfo buildInfo, ArtifactoryServer server) {
        this.buildInfo = buildInfo;
        this.server = server;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public ArtifactoryServer getServer() {
        return this.server;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "publishBuildInfo";
        }

        public String getDisplayName() {
            return "Publish build Info to Artifactory";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @Inject(optional=true)
        private transient PublishBuildInfoStep step;

        protected Boolean run() throws Exception {
            new PublishBuildInfoExecutor(this.build, this.listener, this.step.getBuildInfo(), this.step.getServer()).execute();
            return true;
        }
    }
}

