/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.NpmInstallExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.NpmBuild;
import org.kohsuke.stapler.DataBoundConstructor;

public class NpmInstallStep
extends AbstractStepImpl {
    private BuildInfo buildInfo;
    private NpmBuild npmBuild;
    private String path;
    private String args;

    @DataBoundConstructor
    public NpmInstallStep(BuildInfo buildInfo, NpmBuild npmBuild, String path, String args) {
        this.buildInfo = buildInfo;
        this.npmBuild = npmBuild;
        this.path = path;
        this.args = args;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "artifactoryNpmInstall";
        }

        public String getDisplayName() {
            return "Run Artifactory npm install";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run build;
        @Inject(optional=true)
        private transient NpmInstallStep step;

        protected BuildInfo run() throws Exception {
            String npmExe = Utils.getNpmExe(this.ws, this.listener, this.env, this.launcher, this.step.npmBuild.getTool());
            NpmInstallExecutor npmInstallExecutor = new NpmInstallExecutor(this.step.buildInfo, this.step.npmBuild, npmExe, this.step.args, this.ws, this.step.path, this.env, this.listener, this.build);
            npmInstallExecutor.execute();
            return npmInstallExecutor.getBuildInfo();
        }
    }
}

