/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.executors.GetArtifactoryServerExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.kohsuke.stapler.DataBoundConstructor;

public class GetArtifactoryServerStep
extends AbstractStepImpl {
    private String artifactoryServerID;

    @DataBoundConstructor
    public GetArtifactoryServerStep(String artifactoryServerID) {
        this.artifactoryServerID = artifactoryServerID;
    }

    private String getArtifactoryServerID() {
        return this.artifactoryServerID;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "getArtifactoryServer";
        }

        public String getDisplayName() {
            return "Get Artifactory server from Jenkins config";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<ArtifactoryServer> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @Inject(optional=true)
        private transient GetArtifactoryServerStep step;

        protected ArtifactoryServer run() throws Exception {
            String artifactoryServerID = this.step.getArtifactoryServerID();
            GetArtifactoryServerExecutor getArtifactoryServerExecutor = new GetArtifactoryServerExecutor(this.build, this.getContext(), artifactoryServerID);
            getArtifactoryServerExecutor.execute();
            return getArtifactoryServerExecutor.getArtifactoryServer();
        }
    }
}

