/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Map;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.build.extractor.clientConfiguration.util.EditPropertiesHelper;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.EditPropsExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.kohsuke.stapler.DataBoundConstructor;

public class EditPropsStep
extends AbstractStepImpl {
    private ArtifactoryServer server;
    private String spec;
    private EditPropertiesHelper.EditPropertiesActionType editType;
    private String props;
    private boolean failNoOp;

    @DataBoundConstructor
    public EditPropsStep(String spec, String props, boolean failNoOp, ArtifactoryServer server, EditPropertiesHelper.EditPropertiesActionType editType) {
        this.spec = spec;
        this.editType = editType;
        this.props = props;
        this.server = server;
        this.failNoOp = failNoOp;
    }

    public EditPropertiesHelper.EditPropertiesActionType getEditType() {
        return this.editType;
    }

    public String getProps() {
        return this.props;
    }

    public String getSpec() {
        return this.spec;
    }

    public ArtifactoryServer getServer() {
        return this.server;
    }

    public boolean getFailNoOp() {
        return this.failNoOp;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "artifactoryEditProps";
        }

        public String getDisplayName() {
            return "Edit properties";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;
        @Inject(optional=true)
        private transient EditPropsStep step;

        protected Boolean run() throws Exception {
            new EditPropsExecutor(Utils.prepareArtifactoryServer(null, this.step.getServer()), this.listener, this.build, this.ws, Util.replaceMacro((String)this.step.getSpec(), (Map)this.env), this.step.getEditType(), this.step.getProps(), this.step.getFailNoOp()).execute();
            return true;
        }
    }
}

