/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.cli.MissingArgumentException;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.docker.utils.DockerAgentUtils;
import org.jfrog.hudson.pipeline.common.docker.utils.DockerUtils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerPullStep
extends AbstractStepImpl {
    private final String image;
    private final ArtifactoryServer server;
    private String host;
    private final BuildInfo buildInfo;

    @DataBoundConstructor
    public DockerPullStep(String image, String host, BuildInfo buildInfo, ArtifactoryServer server) {
        this.image = image;
        this.host = host;
        this.buildInfo = buildInfo;
        this.server = server;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getImage() {
        return this.image;
    }

    public ArtifactoryServer getServer() {
        return this.server;
    }

    public String getHost() {
        return this.host;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "dockerPullStep";
        }

        public String getDisplayName() {
            return "Artifactory docker pull";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient DockerPullStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient Launcher launcher;

        protected BuildInfo run() throws Exception {
            if (this.step.getImage() == null) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Missing 'image' parameter"));
                return null;
            }
            BuildInfo buildInfo = Utils.prepareBuildinfo(this.build, this.step.getBuildInfo());
            String imageTag = this.step.getImage();
            if (!DockerUtils.isImageVersioned(imageTag).booleanValue()) {
                imageTag = imageTag + ":latest";
            }
            ArtifactoryServer server = this.step.getServer();
            String username = server.createCredentialsConfig().provideUsername((Item)this.build.getParent());
            String password = server.createCredentialsConfig().providePassword((Item)this.build.getParent());
            DockerAgentUtils.pullImage(this.launcher, imageTag, username, password, this.step.getHost());
            JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
            log.info("Successfully pulled docker image: " + imageTag);
            return buildInfo;
        }
    }
}

