/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.kohsuke.stapler.DataBoundConstructor;

public class DeployStep
extends AbstractStepImpl {
    private Deployer deployer;
    private BuildInfo buildInfo;

    @DataBoundConstructor
    public DeployStep(Deployer deployer, BuildInfo buildInfo) {
        this.deployer = deployer;
        this.buildInfo = buildInfo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "deployArtifacts";
        }

        public String getDisplayName() {
            return "Deploy artifacts";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient DeployStep step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient TaskListener listener;

        protected Boolean run() throws Exception {
            this.step.deployer.deployArtifacts(this.step.buildInfo, this.listener, this.ws);
            return true;
        }
    }
}

