/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Env;
import org.kohsuke.stapler.DataBoundConstructor;

public class CollectEnvStep
extends AbstractStepImpl {
    private Env env;

    @DataBoundConstructor
    public CollectEnvStep(Env env) {
        this.env = env;
    }

    public Env getEnv() {
        return this.env;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "collectEnv";
        }

        public String getDisplayName() {
            return "Collect environment variables and system properties";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient CollectEnvStep step;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;

        protected Boolean run() throws Exception {
            this.step.getEnv().collectVariables(this.env, this.build, this.listener);
            return true;
        }
    }
}

