/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import java.util.List;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.kohsuke.stapler.DataBoundConstructor;

public class AddInteractivePromotionStep
extends AbstractStepImpl {
    private ArtifactoryServer server;
    private PromotionConfig promotionConfig;
    private String displayName;

    @DataBoundConstructor
    public AddInteractivePromotionStep(PromotionConfig promotionConfig, ArtifactoryServer server, String displayName) {
        this.promotionConfig = promotionConfig;
        this.server = server;
        this.displayName = displayName;
    }

    public ArtifactoryServer getServer() {
        return this.server;
    }

    public PromotionConfig getPromotionConfig() {
        return this.promotionConfig;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "addInteractivePromotion";
        }

        public String getDisplayName() {
            return "Add interactive promotion";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @Inject(optional=true)
        private transient AddInteractivePromotionStep step;

        protected Boolean run() throws Exception {
            ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(Utils.prepareArtifactoryServer(null, this.step.getServer()));
            this.addPromotionAction(configurator);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPromotionAction(ArtifactoryConfigurator configurator) {
            PromotionConfig pipelinePromotionConfig = this.step.getPromotionConfig();
            org.jfrog.hudson.release.promotion.PromotionConfig promotionConfig = Utils.convertPromotionConfig(pipelinePromotionConfig);
            List list = this.build.getActions();
            synchronized (list) {
                UnifiedPromoteBuildAction action = (UnifiedPromoteBuildAction)this.build.getAction(UnifiedPromoteBuildAction.class);
                if (action == null) {
                    action = new UnifiedPromoteBuildAction(this.build);
                    this.build.getActions().add(action);
                }
                action.addPromotionCandidate(promotionConfig, configurator, this.step.getDisplayName());
            }
        }
    }
}

