/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps.npm;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.NpmInstallExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.NpmBuild;
import org.jfrog.hudson.pipeline.common.types.resolvers.NpmResolver;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class NpmInstallStep
extends AbstractStepImpl {
    private NpmBuild npmBuild = new NpmBuild();
    private String customBuildNumber;
    private String customBuildName;
    private String resolverId;
    private String path;
    private String args;

    @DataBoundConstructor
    public NpmInstallStep() {
    }

    @DataBoundSetter
    public void setBuildNumber(String customBuildNumber) {
        this.customBuildNumber = customBuildNumber;
    }

    @DataBoundSetter
    public void setBuildName(String customBuildName) {
        this.customBuildName = customBuildName;
    }

    @DataBoundSetter
    public void setResolverId(String resolverId) {
        this.resolverId = resolverId;
    }

    @DataBoundSetter
    public void setPath(String path) {
        this.path = path;
    }

    @DataBoundSetter
    public void setArgs(String args) {
        this.args = args;
    }

    @DataBoundSetter
    public void setTool(String tool) {
        this.npmBuild.setTool(tool);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "rtNpmInstall";
        }

        public String getDisplayName() {
            return "run Artifactory npm install";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;
        @StepContextParameter
        private transient Run build;
        @Inject(optional=true)
        private transient NpmInstallStep step;

        protected Void run() throws Exception {
            BuildInfo buildInfo = DeclarativePipelineUtils.getBuildInfo(this.ws, this.build, this.step.customBuildName, this.step.customBuildNumber);
            this.setResolver(BuildUniqueIdentifierHelper.getBuildNumber(this.build));
            String npmExe = Utils.getNpmExe(this.ws, this.listener, this.env, this.launcher, this.step.npmBuild.getTool());
            NpmInstallExecutor npmInstallExecutor = new NpmInstallExecutor(buildInfo, this.step.npmBuild, npmExe, this.step.args, this.ws, this.step.path, this.env, this.listener, this.build);
            npmInstallExecutor.execute();
            DeclarativePipelineUtils.saveBuildInfo(npmInstallExecutor.getBuildInfo(), this.ws, this.build, new JenkinsBuildInfoLog(this.listener));
            return null;
        }

        private void setResolver(String buildNumber) throws IOException, InterruptedException {
            if (StringUtils.isBlank((String)this.step.resolverId)) {
                return;
            }
            BuildDataFile buildDataFile = DeclarativePipelineUtils.readBuildDataFile(this.ws, buildNumber, "rtNpmResolver", this.step.resolverId);
            if (buildDataFile == null) {
                throw new IOException("Resolver " + this.step.resolverId + " doesn't exist!");
            }
            NpmResolver resolver = (NpmResolver)Utils.mapper().treeToValue((TreeNode)buildDataFile.get("rtNpmResolver"), NpmResolver.class);
            resolver.setServer(this.getArtifactoryServer(buildNumber, buildDataFile));
            this.step.npmBuild.setResolver(resolver);
        }

        private ArtifactoryServer getArtifactoryServer(String buildNumber, BuildDataFile buildDataFile) throws IOException, InterruptedException {
            JsonNode serverId = buildDataFile.get("serverId");
            if (serverId.isNull()) {
                throw new IllegalArgumentException("server ID is missing");
            }
            return DeclarativePipelineUtils.getArtifactoryServer(this.build, this.ws, this.getContext(), serverId.asText());
        }
    }
}

