/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.List;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.jfrog.hudson.pipeline.declarative.steps.PromoteBuildStep;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class InteractivePromotionStep
extends PromoteBuildStep {
    public static final String STEP_NAME = "rtAddInteractivePromotion";
    private String displayName;

    @DataBoundConstructor
    public InteractivePromotionStep(String serverId) {
        super(serverId, "");
    }

    @DataBoundSetter
    public void setTargetRepo(String targetRepo) {
        this.promotionConfig.setTargetRepo(targetRepo);
    }

    @DataBoundSetter
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return InteractivePromotionStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Add interactive promotion";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient TaskListener listener;
        @Inject(optional=true)
        private transient InteractivePromotionStep step;

        protected Boolean run() throws Exception {
            ArtifactoryServer server = DeclarativePipelineUtils.getArtifactoryServer(this.build, this.ws, this.getContext(), this.step.serverId);
            ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(Utils.prepareArtifactoryServer(null, server));
            this.addPromotionAction(configurator);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPromotionAction(ArtifactoryConfigurator configurator) {
            PromotionConfig pipelinePromotionConfig = this.step.preparePromotionConfig(this.build);
            org.jfrog.hudson.release.promotion.PromotionConfig promotionConfig = Utils.convertPromotionConfig(pipelinePromotionConfig);
            List list = this.build.getActions();
            synchronized (list) {
                UnifiedPromoteBuildAction action = (UnifiedPromoteBuildAction)this.build.getAction(UnifiedPromoteBuildAction.class);
                if (action == null) {
                    action = new UnifiedPromoteBuildAction(this.build);
                    this.build.getActions().add(action);
                }
                action.addPromotionCandidate(promotionConfig, configurator, this.step.displayName);
            }
        }
    }
}

