/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.declarative.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.declarative.BuildDataFile;
import org.jfrog.hudson.pipeline.declarative.utils.DeclarativePipelineUtils;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CreateServerStep
extends AbstractStepImpl {
    public static final String STEP_NAME = "rtServer";
    private BuildDataFile buildDataFile;
    private ArtifactoryServer server;

    @DataBoundConstructor
    public CreateServerStep(String id) {
        this.buildDataFile = new BuildDataFile(STEP_NAME, id);
        this.server = new ArtifactoryServer();
        this.buildDataFile.putPOJO(this.server);
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.server.setUrl(url);
    }

    @DataBoundSetter
    public void setUsername(String username) {
        this.server.setUsername(username);
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.server.setPassword(password);
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.server.setCredentialsId(credentialsId);
    }

    @DataBoundSetter
    public void setBypassProxy(boolean bypassProxy) {
        this.server.setBypassProxy(bypassProxy);
    }

    @DataBoundSetter
    public void setTimeout(int timeout) {
        this.server.getConnection().setTimeout(timeout);
    }

    @DataBoundSetter
    public void setRetry(int retry) {
        this.server.getConnection().setRetry(retry);
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return CreateServerStep.STEP_NAME;
        }

        public String getDisplayName() {
            return "Creates new Artifactory server";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient Run build;
        @Inject(optional=true)
        private transient CreateServerStep step;

        protected Void run() throws Exception {
            String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(this.build);
            DeclarativePipelineUtils.writeBuildDataFile(this.ws, buildNumber, this.step.buildDataFile, new JenkinsBuildInfoLog(this.listener));
            return null;
        }
    }
}

