/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.buildInfo;

import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfrog.build.api.Module;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.docker.DockerImage;
import org.jfrog.hudson.pipeline.common.docker.utils.DockerAgentUtils;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;

public class DockerBuildInfoHelper
implements Serializable {
    private BuildInfo buildInfo;
    private List<Integer> aggregatedBuildInfoIds = new ArrayList<Integer>();

    public DockerBuildInfoHelper(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public List<Module> generateBuildInfoModules(Run build, TaskListener listener, ArtifactoryConfigurator config) throws IOException, InterruptedException {
        this.aggregatedBuildInfoIds.add(this.buildInfo.hashCode());
        ArrayList<DockerImage> dockerImages = new ArrayList<DockerImage>();
        for (Integer buildInfoId : this.aggregatedBuildInfoIds) {
            dockerImages.addAll(DockerAgentUtils.getDockerImagesFromAgents(buildInfoId, listener));
        }
        String timestamp = Long.toString(this.buildInfo.getStartDate().getTime());
        ArrayList<Module> modules = new ArrayList<Module>();
        for (DockerImage dockerImage : dockerImages) {
            modules.add(dockerImage.generateBuildInfoModule(build, listener, config, this.buildInfo.getName(), this.buildInfo.getNumber(), timestamp));
        }
        return modules;
    }

    public void append(DockerBuildInfoHelper other) {
        this.aggregatedBuildInfoIds.add(other.buildInfo.hashCode());
    }
}

