/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types.buildInfo;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.BaseBuildFileBean;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.client.DeployableArtifactDetail;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployableArtifactsUtils;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.BuildInfoDeployer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfoAccessor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildRetention;
import org.jfrog.hudson.pipeline.common.types.buildInfo.DockerBuildInfoHelper;
import org.jfrog.hudson.pipeline.common.types.buildInfo.Env;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;

public class BuildInfo
implements Serializable {
    public static final long serialVersionUID = 1L;
    private String name;
    private String number;
    private Date startDate;
    private BuildRetention retention;
    private List<BuildDependency> buildDependencies = new CopyOnWriteArrayList<BuildDependency>();
    private List<Artifact> deployedArtifacts = new CopyOnWriteArrayList<Artifact>();
    private List<DeployDetails> deployableArtifacts = new CopyOnWriteArrayList<DeployDetails>();
    private List<Dependency> publishedDependencies = new CopyOnWriteArrayList<Dependency>();
    private List<Module> modules = new CopyOnWriteArrayList<Module>();
    private Env env = new Env();
    private String agentName;
    private transient DockerBuildInfoHelper dockerBuildInfoHelper = new DockerBuildInfoHelper(this);

    public BuildInfo() {
        this.startDate = Calendar.getInstance().getTime();
        this.retention = new BuildRetention();
    }

    public BuildInfo(Run build) {
        this();
        this.name = BuildUniqueIdentifierHelper.getBuildName(build);
        this.number = BuildUniqueIdentifierHelper.getBuildNumber(build);
    }

    @Whitelisted
    public void setName(String name) {
        this.name = name;
    }

    @Whitelisted
    public void setNumber(String number) {
        this.number = number;
    }

    @Whitelisted
    public String getName() {
        return this.name;
    }

    @Whitelisted
    public String getNumber() {
        return this.number;
    }

    @Whitelisted
    public Date getStartDate() {
        return this.startDate;
    }

    @Whitelisted
    public void setStartDate(Date date) {
        this.startDate = date;
    }

    @Whitelisted
    public List<org.jfrog.hudson.pipeline.types.File> getArtifacts() {
        Stream dependencyStream = Stream.concat(this.modules.parallelStream().map(Module::getArtifacts).filter(Objects::nonNull).flatMap(Collection::stream), this.deployedArtifacts.parallelStream());
        return this.getBuildFilesList(dependencyStream);
    }

    @Whitelisted
    public List<org.jfrog.hudson.pipeline.types.File> getDependencies() {
        Stream dependencyStream = Stream.concat(this.modules.parallelStream().map(Module::getDependencies).filter(Objects::nonNull).flatMap(Collection::stream), this.publishedDependencies.parallelStream());
        return this.getBuildFilesList(dependencyStream);
    }

    private List<org.jfrog.hudson.pipeline.types.File> getBuildFilesList(Stream<? extends BaseBuildFileBean> buildFilesStream) {
        return buildFilesStream.filter(buildFile -> StringUtils.isNotBlank((String)buildFile.getLocalPath())).filter(buildFile -> StringUtils.isNotBlank((String)buildFile.getRemotePath())).map(org.jfrog.hudson.pipeline.types.File::new).distinct().collect(Collectors.toList());
    }

    @Whitelisted
    public void append(BuildInfo other) {
        this.modules.addAll(other.modules);
        this.deployedArtifacts.addAll(other.deployedArtifacts);
        this.deployableArtifacts.addAll(other.deployableArtifacts);
        this.publishedDependencies.addAll(other.publishedDependencies);
        this.buildDependencies.addAll(other.buildDependencies);
        this.dockerBuildInfoHelper.append(other.dockerBuildInfoHelper);
        Env tempEnv = new Env();
        tempEnv.append(this.env);
        tempEnv.append(other.env);
        this.env = tempEnv;
    }

    public void append(Build other) {
        Properties properties = other.getProperties();
        Env otherEnv = new Env();
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                boolean isEnvVar = StringUtils.startsWith((String)key, (String)"buildInfo.env.");
                if (isEnvVar) {
                    otherEnv.getEnvVars().put(StringUtils.substringAfter((String)key, (String)"buildInfo.env."), properties.getProperty(key));
                    continue;
                }
                otherEnv.getSysVars().put(key, properties.getProperty(key));
            }
            this.env.append(otherEnv);
        }
        if (other.getModules() != null) {
            other.getModules().forEach(this::addModule);
        }
        if (other.getBuildDependencies() != null) {
            this.buildDependencies.addAll(other.getBuildDependencies());
        }
    }

    @Whitelisted
    public Env getEnv() {
        return this.env;
    }

    @Whitelisted
    public BuildRetention getRetention() {
        return this.retention;
    }

    @Whitelisted
    public void retention(Map<String, Object> retentionArguments) {
        Set<String> retentionArgumentsSet = retentionArguments.keySet();
        List<String> keysAsList = Arrays.asList("maxDays", "maxBuilds", "deleteBuildArtifacts", "doNotDiscardBuilds", "async");
        if (!keysAsList.containsAll(retentionArgumentsSet)) {
            throw new IllegalArgumentException("Only the following arguments are allowed: " + keysAsList.toString());
        }
        ObjectMapper mapper = new ObjectMapper();
        this.retention = (BuildRetention)mapper.convertValue(retentionArguments, BuildRetention.class);
    }

    void appendDeployedArtifacts(List<Artifact> artifacts) {
        if (artifacts == null) {
            return;
        }
        this.deployedArtifacts.addAll(artifacts);
    }

    public List<DeployDetails> getDeployableArtifacts() {
        return this.deployableArtifacts;
    }

    public void appendDeployableArtifacts(String deployableArtifactsPath, FilePath ws, TaskListener listener) throws IOException, InterruptedException {
        List deployableArtifacts = (List)ws.act((FilePath.FileCallable)new DeployPathsAndPropsCallable(deployableArtifactsPath, listener, this));
        this.deployableArtifacts.addAll(deployableArtifacts);
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    protected void appendBuildDependencies(List<BuildDependency> dependencies) {
        if (dependencies == null) {
            return;
        }
        this.buildDependencies.addAll(dependencies);
    }

    void appendPublishedDependencies(List<Dependency> dependencies) {
        if (dependencies == null) {
            return;
        }
        this.publishedDependencies.addAll(dependencies);
    }

    List<BuildDependency> getBuildDependencies() {
        return this.buildDependencies;
    }

    Map<String, String> getEnvVars() {
        return this.env.getEnvVars();
    }

    Map<String, String> getSysVars() {
        return this.env.getSysVars();
    }

    BuildInfoDeployer createDeployer(Run build, TaskListener listener, ArtifactoryConfigurator config, ArtifactoryBuildInfoClient client) throws InterruptedException, NoSuchAlgorithmException, IOException {
        this.addDefaultModuleToModules(this.name);
        return new BuildInfoDeployer(config, client, build, listener, new BuildInfoAccessor(this));
    }

    private void addDockerBuildInfoModules(List<Module> dockerModules) {
        this.modules.addAll(dockerModules);
    }

    private void addDefaultModuleToModules(String moduleId) {
        if (this.deployedArtifacts.isEmpty() && this.publishedDependencies.isEmpty()) {
            return;
        }
        ModuleBuilder moduleBuilder = new ModuleBuilder().id(moduleId).artifacts(this.deployedArtifacts).dependencies(this.publishedDependencies);
        this.modules.add(moduleBuilder.build());
    }

    public void setCpsScript(CpsScript cpsScript) {
        this.env.setCpsScript(cpsScript);
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public void setRetention(BuildRetention retention) {
        this.retention = retention;
    }

    public void setBuildDependencies(List<BuildDependency> buildDependencies) {
        this.buildDependencies = buildDependencies;
    }

    public List<Artifact> getDeployedArtifacts() {
        return this.deployedArtifacts;
    }

    public void setDeployedArtifacts(List<Artifact> deployedArtifacts) {
        this.deployedArtifacts = deployedArtifacts;
    }

    public void setDeployableArtifacts(List<DeployDetails> deployableArtifacts) {
        this.deployableArtifacts = deployableArtifacts;
    }

    public List<Dependency> getPublishedDependencies() {
        return this.publishedDependencies;
    }

    public void setPublishedDependencies(List<Dependency> publishedDependencies) {
        this.publishedDependencies = publishedDependencies;
    }

    public void setModules(List<Module> modules) {
        this.modules = modules;
    }

    public void setEnv(Env env) {
        this.env = env;
    }

    private void addModule(Module other) {
        List<Module> modules = this.getModules();
        Module currentModule = modules.stream().filter(module -> StringUtils.equals((String)module.getId(), (String)other.getId())).findAny().orElse(null);
        if (currentModule == null) {
            modules.add(other);
        } else {
            currentModule.append(other);
        }
    }

    public static class DeployPathsAndPropsCallable
    extends MasterToSlaveFileCallable<List<DeployDetails>> {
        private String deployableArtifactsPath;
        private TaskListener listener;
        private ArrayListMultimap<String, String> propertiesMap;

        DeployPathsAndPropsCallable(String deployableArtifactsPath, TaskListener listener, BuildInfo buildInfo) {
            this.deployableArtifactsPath = deployableArtifactsPath;
            this.listener = listener;
            this.propertiesMap = this.getbuildPropertiesMap(buildInfo);
        }

        public List<DeployDetails> invoke(File file, VirtualChannel virtualChannel) throws IOException {
            ArrayList<DeployDetails> results = new ArrayList<DeployDetails>();
            try {
                File deployableArtifactsFile = new File(this.deployableArtifactsPath);
                List deployableArtifacts = DeployableArtifactsUtils.loadDeployableArtifactsFromFile((File)deployableArtifactsFile);
                deployableArtifactsFile.delete();
                for (DeployableArtifactDetail artifact : deployableArtifacts) {
                    DeployDetails.Builder builder = new DeployDetails.Builder().file(new File(artifact.getSourcePath())).artifactPath(artifact.getArtifactDest()).addProperties(this.propertiesMap).targetRepository("empty_repo").sha1(artifact.getSha1());
                    results.add(builder.build());
                }
                return results;
            }
            catch (ClassNotFoundException e) {
                ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)this.listener.getLogger());
                return results;
            }
        }

        private ArrayListMultimap<String, String> getbuildPropertiesMap(BuildInfo buildInfo) {
            ArrayListMultimap properties = ArrayListMultimap.create();
            properties.put((Object)"build.name", (Object)buildInfo.getName());
            properties.put((Object)"build.number", (Object)buildInfo.getNumber());
            properties.put((Object)"build.timestamp", (Object)(buildInfo.getStartDate().getTime() + ""));
            return properties;
        }
    }
}

