/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.types;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;

public class ConanRemote
implements Serializable {
    private transient CpsScript cpsScript;
    private String conanHome;

    public void setCpsScript(CpsScript cpsScript) {
        this.cpsScript = cpsScript;
    }

    public void setConanHome(String conanHome) {
        this.conanHome = conanHome;
    }

    @Whitelisted
    public String add(Map<String, Object> args) {
        if (!args.containsKey("server") || !args.containsKey("repo")) {
            throw new IllegalArgumentException("server and repo are mandatory arguments.");
        }
        ArtifactoryServer server = (ArtifactoryServer)args.get("server");
        String serverName = UUID.randomUUID().toString();
        String repo = (String)args.get("repo");
        this.cpsScript.invokeMethod("conanAddRemote", this.getAddRemoteExecutionArguments(server, serverName, repo));
        this.cpsScript.invokeMethod("conanAddUser", this.getAddUserExecutionArguments(server, serverName));
        return serverName;
    }

    private Map<String, Object> getAddRemoteExecutionArguments(ArtifactoryServer server, String serverName, String repo) {
        String serverUrl = this.buildConanRemoteUrl(server, repo);
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("serverUrl", serverUrl);
        stepVariables.put("serverName", serverName);
        stepVariables.put("conanHome", this.conanHome);
        return stepVariables;
    }

    private String buildConanRemoteUrl(ArtifactoryServer server, String repo) {
        StringBuilder serverURL = new StringBuilder(server.getUrl());
        if (!StringUtils.endsWith((String)serverURL.toString(), (String)"/")) {
            serverURL.append("/");
        }
        serverURL.append("api/conan/").append(repo);
        return serverURL.toString();
    }

    private Map<String, Object> getAddUserExecutionArguments(ArtifactoryServer server, String serverName) {
        LinkedHashMap stepVariables = Maps.newLinkedHashMap();
        stepVariables.put("server", server);
        stepVariables.put("serverName", serverName);
        stepVariables.put("conanHome", this.conanHome);
        return stepVariables;
    }
}

