/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jfrog.build.api.builder.PromotionBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.types.PromotionConfig;
import org.jfrog.hudson.release.PromotionUtils;
import org.jfrog.hudson.util.CredentialManager;

public class PromotionExecutor
implements Executor {
    private final ArtifactoryServer server;
    private final TaskListener listener;
    private final PromotionConfig promotionConfig;
    private final StepContext context;
    private Run build;

    public PromotionExecutor(ArtifactoryServer server, Run build, TaskListener listener, StepContext context, PromotionConfig promotionConfig) {
        this.server = server;
        this.build = build;
        this.listener = listener;
        this.context = context;
        this.promotionConfig = promotionConfig;
    }

    @Override
    public void execute() throws IOException {
        ArtifactoryConfigurator configurator = new ArtifactoryConfigurator(this.server);
        CredentialsConfig deployerConfig = CredentialManager.getPreferredDeployer(configurator, this.server);
        ArtifactoryBuildInfoClient client = this.server.createArtifactoryClient(deployerConfig.provideUsername((Item)this.build.getParent()), deployerConfig.providePassword((Item)this.build.getParent()), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));
        PromotionBuilder promotionBuilder = new PromotionBuilder().status(this.promotionConfig.getStatus()).comment(this.promotionConfig.getComment()).targetRepo(this.promotionConfig.getTargetRepo()).sourceRepo(this.promotionConfig.getSourceRepo()).dependencies(this.promotionConfig.isIncludeDependencies()).copy(this.promotionConfig.isCopy()).failFast(this.promotionConfig.isFailFast());
        this.logInfo();
        boolean status = PromotionUtils.promoteAndCheckResponse(promotionBuilder.build(), client, this.listener, this.promotionConfig.getBuildName(), this.promotionConfig.getBuildNumber());
        if (!status) {
            this.context.onFailure((Throwable)new Exception("Build promotion failed"));
        }
    }

    private void logInfo() {
        StringBuilder strBuilder = new StringBuilder().append("Promoting '").append(this.promotionConfig.getBuildName()).append("' ").append("#").append(this.promotionConfig.getBuildNumber()).append(" to '").append(this.promotionConfig.getTargetRepo()).append("'");
        if (StringUtils.isNotEmpty((String)this.promotionConfig.getSourceRepo())) {
            strBuilder.append(" from '").append(this.promotionConfig.getSourceRepo()).append("'");
        }
        if (StringUtils.isNotEmpty((String)this.promotionConfig.getStatus())) {
            strBuilder.append(", with status: '").append(this.promotionConfig.getStatus()).append("'");
        }
        if (StringUtils.isNotEmpty((String)this.promotionConfig.getComment())) {
            strBuilder.append(", with comment: '").append(this.promotionConfig.getComment()).append("'");
        }
        if (this.promotionConfig.isIncludeDependencies()) {
            strBuilder.append(", including dependencies");
        }
        if (this.promotionConfig.isCopy()) {
            strBuilder.append(", using copy");
        }
        if (this.promotionConfig.isFailFast()) {
            strBuilder.append(", failing on first error");
        }
        this.listener.getLogger().println(strBuilder.append(".").toString());
    }
}

