/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.maven3.Maven3Builder;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.pipeline.common.executors.MavenGradleEnvExtractor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.deployers.Deployer;
import org.jfrog.hudson.pipeline.common.types.deployers.MavenDeployer;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.MavenBuild;
import org.jfrog.hudson.util.ExtractorUtils;

public class MavenExecutor
implements Executor {
    private TaskListener listener;
    private Launcher launcher;
    private Run build;
    private FilePath ws;
    private EnvVars env;
    private MavenBuild mavenBuild;
    private String pom;
    private String goals;
    private BuildInfo buildInfo;

    public MavenExecutor(TaskListener listener, Launcher launcher, Run build, FilePath ws, EnvVars env, MavenBuild mavenBuild, String pom, String goals, BuildInfo buildInfo) {
        this.listener = listener;
        this.launcher = launcher;
        this.build = build;
        this.ws = ws;
        this.env = env;
        this.mavenBuild = mavenBuild;
        this.pom = pom;
        this.goals = goals;
        this.buildInfo = Utils.prepareBuildinfo(build, buildInfo);
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Override
    public void execute() throws Exception {
        Deployer deployer = this.getDeployer(this.mavenBuild);
        deployer.createPublisherBuildInfoDetails(this.buildInfo);
        String revision = Utils.extractVcsRevision(new FilePath(this.ws, this.pom));
        EnvVars extendedEnv = new EnvVars(this.env);
        extendedEnv.put("GIT_COMMIT", revision);
        FilePath tempDir = ExtractorUtils.createAndGetTempDir(this.ws);
        MavenGradleEnvExtractor envExtractor = new MavenGradleEnvExtractor(this.build, this.buildInfo, deployer, this.mavenBuild.getResolver(), this.listener, this.launcher, tempDir, extendedEnv);
        envExtractor.execute();
        String stepOpts = this.mavenBuild.getOpts();
        String mavenOpts = stepOpts + (extendedEnv.get((Object)"MAVEN_OPTS") != null ? (stepOpts.length() > 0 ? " " : "") + (String)extendedEnv.get((Object)"MAVEN_OPTS") : "");
        mavenOpts = mavenOpts.replaceAll("[\t\r\n]+", " ");
        if (!this.mavenBuild.getResolver().isEmpty()) {
            extendedEnv.put("buildInfoConfig.artifactoryResolutionEnabled", Boolean.TRUE.toString());
        }
        Maven3Builder maven3Builder = new Maven3Builder(this.mavenBuild.getTool(), this.pom, this.goals, mavenOpts);
        this.convertJdkPath(this.launcher, extendedEnv);
        boolean buildResult = maven3Builder.perform(this.build, this.launcher, this.listener, extendedEnv, this.ws, tempDir);
        if (!buildResult) {
            throw new RuntimeException("Maven build failed");
        }
        String generatedBuildPath = (String)extendedEnv.get((Object)"generated.build.info");
        this.buildInfo.append(Utils.getGeneratedBuildInfo(this.build, this.listener, this.launcher, generatedBuildPath));
        this.buildInfo.appendDeployableArtifacts((String)extendedEnv.get((Object)"deployable.artifacts"), tempDir, this.listener);
        this.buildInfo.setAgentName(Utils.getAgentName(this.ws));
    }

    private void convertJdkPath(Launcher launcher, EnvVars extendedEnv) {
        String separator = launcher.isUnix() ? "/" : "\\";
        String java_home = (String)extendedEnv.get((Object)"JAVA_HOME");
        if (StringUtils.isNotEmpty((String)java_home)) {
            if (!StringUtils.endsWith((String)java_home, (String)separator)) {
                java_home = java_home + separator;
            }
            extendedEnv.put("PATH+JDK", java_home + "bin");
        }
    }

    private Deployer getDeployer(MavenBuild mavenBuild) {
        Deployer deployer = mavenBuild.getDeployer();
        if (deployer == null || deployer.isEmpty()) {
            deployer = MavenDeployer.EMPTY_DEPLOYER;
        }
        return deployer;
    }
}

