/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.common.executors;

import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import org.jfrog.build.extractor.clientConfiguration.util.EditPropertiesHelper;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.generic.EditPropertiesCallable;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.Executor;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class EditPropsExecutor
implements Executor {
    private final Run build;
    private transient FilePath ws;
    private ArtifactoryServer server;
    private TaskListener listener;
    private String spec;
    private EditPropertiesHelper.EditPropertiesActionType editType;
    private String props;
    private boolean failNoOp;

    public EditPropsExecutor(ArtifactoryServer server, TaskListener listener, Run build, FilePath ws, String spec, EditPropertiesHelper.EditPropertiesActionType editType, String props, boolean failNoOp) {
        this.build = build;
        this.server = server;
        this.listener = listener;
        this.props = props;
        this.editType = editType;
        this.ws = ws;
        this.spec = spec;
        this.failNoOp = failNoOp;
    }

    @Override
    public void execute() throws IOException, InterruptedException {
        CredentialsConfig preferredDeployer = this.server.getDeployerCredentialsConfig();
        Boolean success = (Boolean)this.ws.act((FilePath.FileCallable)new EditPropertiesCallable(new JenkinsBuildInfoLog(this.listener), preferredDeployer.provideUsername((Item)this.build.getParent()), preferredDeployer.providePassword((Item)this.build.getParent()), this.server.getUrl(), this.spec, Utils.getProxyConfiguration(this.server), this.editType, this.props));
        if (this.failNoOp && !success.booleanValue()) {
            throw new RuntimeException("Fail-no-op: No files were affected while editing properties.");
        }
    }
}

