/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.npm;

import com.google.common.collect.ArrayListMultimap;
import hudson.EnvVars;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryBuildInfoClientBuilder;
import org.jfrog.build.extractor.npm.extractor.NpmPublish;
import org.jfrog.hudson.pipeline.common.Utils;

public class NpmPublishCallable
extends MasterToSlaveFileCallable<Build> {
    private ArtifactoryBuildInfoClientBuilder buildInfoClientBuilder;
    private ArrayListMultimap<String, String> properties;
    private String deploymentRepository;
    private String executablePath;
    private String path;
    private EnvVars env;
    private Log logger;

    public NpmPublishCallable(ArtifactoryBuildInfoClientBuilder buildInfoClientBuilder, ArrayListMultimap<String, String> properties, String deploymentRepository, String executablePath, String path, EnvVars env, Log logger) {
        this.buildInfoClientBuilder = buildInfoClientBuilder;
        this.properties = properties;
        this.deploymentRepository = deploymentRepository;
        this.executablePath = executablePath;
        this.path = path;
        this.env = env;
        this.logger = logger;
    }

    public Build invoke(File file, VirtualChannel channel) {
        Path basePath = file.toPath();
        Path packagePath = StringUtils.isBlank((CharSequence)this.path) ? basePath : basePath.resolve(Utils.replaceTildeWithUserHome(this.path));
        return new NpmPublish(this.buildInfoClientBuilder, this.properties, this.executablePath, packagePath, this.deploymentRepository, this.logger, (Map)this.env).execute();
    }
}

