/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven3.extractor;

import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.model.AbstractBuild;
import hudson.model.BuildableItem;
import org.jfrog.hudson.ArtifactoryRedeployPublisher;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.maven3.ArtifactoryMaven3NativeConfigurator;

public abstract class MavenExtractorHelper {
    public static boolean isDisabled(AbstractBuild build) {
        return MavenExtractorHelper.getPublisherResolverTuple(build) == null;
    }

    public static PublisherResolverTuple getPublisherResolverTuple(AbstractBuild build) {
        if (!(build instanceof MavenModuleSetBuild)) {
            return null;
        }
        MavenModuleSet project = (MavenModuleSet)build.getProject();
        ArtifactoryRedeployPublisher publisher = ActionableHelper.getPublisher(project, ArtifactoryRedeployPublisher.class);
        if (publisher != null && !publisher.isApplicable(build)) {
            publisher = null;
        }
        ArtifactoryMaven3NativeConfigurator resolver = ActionableHelper.getBuildWrapper((BuildableItem)project, ArtifactoryMaven3NativeConfigurator.class);
        if (publisher == null && resolver == null) {
            return null;
        }
        PublisherResolverTuple publisherResolverTuple = new PublisherResolverTuple();
        publisherResolverTuple.publisher = publisher;
        publisherResolverTuple.resolver = resolver;
        return publisherResolverTuple;
    }

    public static PublisherResolverTuple getResolverTuple(AbstractBuild build) {
        if (!(build instanceof MavenModuleSetBuild)) {
            return null;
        }
        MavenModuleSet project = (MavenModuleSet)build.getProject();
        ArtifactoryMaven3NativeConfigurator resolver = ActionableHelper.getBuildWrapper((BuildableItem)project, ArtifactoryMaven3NativeConfigurator.class);
        if (resolver == null) {
            return null;
        }
        PublisherResolverTuple publisherResolverTuple = new PublisherResolverTuple();
        publisherResolverTuple.resolver = resolver;
        return publisherResolverTuple;
    }

    public static class PublisherResolverTuple {
        public ArtifactoryRedeployPublisher publisher;
        public ArtifactoryMaven3NativeConfigurator resolver;
    }
}

