/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.maven3.extractor;

import com.google.common.collect.Lists;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.MavenModuleSet;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.PlexusModuleContributor;
import hudson.maven.PlexusModuleContributorFactory;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Environment;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Which;
import hudson.scm.NullChangeLogParser;
import hudson.scm.NullSCM;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.maven.BuildInfoRecorder;
import org.jfrog.hudson.ArtifactoryRedeployPublisher;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.maven3.ArtifactoryMaven3NativeConfigurator;
import org.jfrog.hudson.maven3.extractor.MavenExtractorHelper;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.ExtractorUtils;
import org.jfrog.hudson.util.MavenVersionHelper;
import org.jfrog.hudson.util.PluginDependencyHelper;
import org.jfrog.hudson.util.ResolverContext;
import org.jfrog.hudson.util.publisher.PublisherContext;
import org.jfrog.hudson.util.publisher.PublisherFlexible;

public class MavenExtractorEnvironment
extends Environment {
    private final ArtifactoryRedeployPublisher publisher;
    private final MavenModuleSetBuild build;
    private final ArtifactoryMaven3NativeConfigurator resolver;
    private final BuildListener buildListener;
    private final EnvVars envVars;
    private String propertiesFilePath;
    private final Launcher launcher;
    private boolean initialized;

    public MavenExtractorEnvironment(MavenModuleSetBuild build, ArtifactoryRedeployPublisher publisher, ArtifactoryMaven3NativeConfigurator resolver, BuildListener buildListener, Launcher launcher) throws IOException, InterruptedException {
        this.buildListener = buildListener;
        this.build = build;
        this.publisher = publisher;
        this.resolver = resolver;
        this.envVars = build.getEnvironment((TaskListener)buildListener);
        this.launcher = launcher;
    }

    public void buildEnvVars(Map<String, String> env) {
        if (this.build.getWorkspace() == null) {
            return;
        }
        if (!(this.initialized || ((MavenModuleSet)this.build.getProject()).getScm() instanceof NullSCM || this.isCheckoutPerformed(env))) {
            return;
        }
        try {
            if (!this.isMavenVersionValid()) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.buildListener.error("Unable to determine Maven version"));
            return;
        }
        if (this.isFlexibleWrapsPublisher((MavenModuleSet)this.build.getProject())) {
            this.buildListener.getLogger().println("Artifactory publisher is wrapped by the Flexible-Publish publisher. Build-Info-Maven3-Extractor is disabled.");
            return;
        }
        env.put("extractor.used", "true");
        ReleaseAction release = ActionableHelper.getLatestAction((Run)this.build, ReleaseAction.class);
        if (release != null) {
            release.addVars(env);
        }
        if (!this.initialized) {
            try {
                PublisherContext publisherContext = null;
                if (this.publisher != null) {
                    publisherContext = this.createPublisherContext(this.publisher, (AbstractBuild)this.build);
                }
                ResolverContext resolverContext = null;
                if (this.resolver != null) {
                    CredentialsConfig resolverCredentials = CredentialManager.getPreferredResolver(this.resolver, this.resolver.getArtifactoryServer());
                    resolverContext = new ResolverContext(this.resolver.getArtifactoryServer(), this.resolver.getResolverDetails(), resolverCredentials.getCredentials((Item)this.build.getProject()), this.resolver);
                }
                ArtifactoryClientConfiguration configuration = ExtractorUtils.addBuilderInfoArguments(env, (Run)this.build, (TaskListener)this.buildListener, publisherContext, resolverContext, this.build.getWorkspace(), this.launcher);
                this.propertiesFilePath = configuration.getPropertiesFile();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.initialized = true;
        }
        if (this.resolver != null) {
            env.put("buildInfoConfig.artifactoryResolutionEnabled", Boolean.TRUE.toString());
        }
        env.put("buildInfoConfig.propertiesFile", this.propertiesFilePath);
    }

    private boolean isCheckoutPerformed(Map<String, String> env) {
        if (StringUtils.isBlank((String)ExtractorUtils.getVcsRevision(env))) {
            return false;
        }
        try {
            Field scmField = AbstractBuild.class.getDeclaredField("scm");
            scmField.setAccessible(true);
            Object scmObject = scmField.get(this.build);
            if (scmObject == null) {
                return false;
            }
            return !(scmObject instanceof NullChangeLogParser);
        }
        catch (Exception e) {
            this.buildListener.getLogger().println("[Warning] An error occurred while testing if the SCM checkout has already been performed: " + e.getMessage());
            return false;
        }
    }

    private boolean isMavenVersionValid() throws Exception {
        return MavenVersionHelper.isAtLeastResolutionCapableVersion(this.build, this.envVars, (TaskListener)this.buildListener);
    }

    private boolean isFlexibleWrapsPublisher(MavenModuleSet project) {
        return new PublisherFlexible<ArtifactoryRedeployPublisher>().isPublisherWrapped((AbstractProject<?, ?>)project, ArtifactoryRedeployPublisher.class);
    }

    private PublisherContext createPublisherContext(ArtifactoryRedeployPublisher publisher, AbstractBuild build) {
        String stagingRepoKey;
        ReleaseAction release = ActionableHelper.getLatestAction((Run)build, ReleaseAction.class);
        ServerDetails server = publisher.getDeployerDetails();
        if (release != null && !StringUtils.isBlank((String)(stagingRepoKey = release.getStagingRepositoryKey())) && !stagingRepoKey.equals(server.getDeployReleaseRepository().getRepoKey())) {
            server = new ServerDetails(server.artifactoryName, server.getArtifactoryUrl(), new RepositoryConf(stagingRepoKey, stagingRepoKey, false), server.getDeploySnapshotRepository(), server.getResolveReleaseRepository(), server.getResolveSnapshotRepository(), server.getDownloadReleaseRepositoryDisplayName(), server.getDownloadSnapshotRepositoryDisplayName());
        }
        PublisherContext context = new PublisherContext.Builder().artifactoryServer(publisher.getArtifactoryServer()).serverDetails(server).deployerOverrider(publisher).discardOldBuilds(publisher.isDiscardOldBuilds()).deployArtifacts(publisher.isDeployArtifacts()).includesExcludes(publisher.getArtifactDeploymentPatterns()).skipBuildInfoDeploy(!publisher.isDeployBuildInfo()).recordAllDependencies(publisher.isRecordAllDependencies()).includeEnvVars(publisher.isIncludeEnvVars()).envVarsPatterns(publisher.getEnvVarsPatterns()).discardBuildArtifacts(publisher.isDiscardBuildArtifacts()).asyncBuildRetention(publisher.isAsyncBuildRetention()).deploymentProperties(publisher.getDeploymentProperties()).evenIfUnstable(publisher.isEvenIfUnstable()).enableIssueTrackerIntegration(publisher.isEnableIssueTrackerIntegration()).aggregateBuildIssues(publisher.isAggregateBuildIssues()).aggregationBuildStatus(publisher.getAggregationBuildStatus()).filterExcludedArtifactsFromBuild(publisher.isFilterExcludedArtifactsFromBuild()).artifactoryPluginVersion(ActionableHelper.getArtifactoryPluginVersion()).overrideBuildName(publisher.isOverrideBuildName()).customBuildName(publisher.getCustomBuildName()).connectionRetry(publisher.getArtifactoryServer().getConnectionRetry()).build();
        return context;
    }

    @Extension
    public static class ArtifactoryPlexusContributor
    extends PlexusModuleContributorFactory {
        private static final String INCLUDED_FILES = "*.jar";
        private static final String EXCLUDED_FILES = "classes.jar, *ivy*, *gradle*, artifactory*.jar";

        public PlexusModuleContributor createFor(AbstractBuild<?, ?> context) throws IOException, InterruptedException {
            if (MavenExtractorHelper.isDisabled(context) || MavenVersionHelper.isLowerThanMaven3((MavenModuleSetBuild)context)) {
                return null;
            }
            File maven3ExtractorJar = Which.jarFile(BuildInfoRecorder.class);
            FilePath dependenciesDirectory = PluginDependencyHelper.getActualDependencyDirectory(maven3ExtractorJar, context.getBuiltOn().getRootPath());
            FilePath[] files = dependenciesDirectory.list(INCLUDED_FILES, EXCLUDED_FILES);
            ArrayList jars = Lists.newArrayList();
            Collections.addAll(jars, files);
            return PlexusModuleContributor.of((List)jars);
        }
    }
}

