/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.AntPatternsDependenciesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.BuildDependenciesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.DependenciesDownloader;
import org.jfrog.hudson.generic.DependenciesDownloaderImpl;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;

public class GenericArtifactsResolver {
    private final AbstractBuild build;
    private final ArtifactoryDependenciesClient client;
    private Log log;
    private EnvVars envVars;

    public GenericArtifactsResolver(AbstractBuild build, BuildListener listener, ArtifactoryDependenciesClient client) throws IOException, InterruptedException {
        this.build = build;
        this.client = client;
        this.envVars = build.getEnvironment((TaskListener)listener);
        this.log = new JenkinsBuildInfoLog((TaskListener)listener);
    }

    public List<Dependency> retrievePublishedDependencies(String resolvePattern) throws IOException, InterruptedException {
        AntPatternsDependenciesHelper helper = new AntPatternsDependenciesHelper(this.createDependenciesDownloader(), this.log);
        return helper.retrievePublishedDependencies(Util.replaceMacro((String)resolvePattern, (Map)this.envVars));
    }

    public List<BuildDependency> retrieveBuildDependencies(String resolvePattern) throws IOException, InterruptedException {
        BuildDependenciesHelper helper = new BuildDependenciesHelper(this.createDependenciesDownloader(), this.log);
        return helper.retrieveBuildDependencies(Util.replaceMacro((String)resolvePattern, (Map)this.envVars));
    }

    private DependenciesDownloader createDependenciesDownloader() {
        return new DependenciesDownloaderImpl(this.client, this.build.getWorkspace(), this.log);
    }
}

