/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import com.google.common.collect.Lists;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class FilesResolverCallable
extends MasterToSlaveFileCallable<List<Dependency>> {
    private Log log;
    private String username;
    private String password;
    private String serverUrl;
    private String downloadSpec;
    private ProxyConfiguration proxyConfig;

    public FilesResolverCallable(Log log, String username, String password, String serverUrl, String downloadSpec, ProxyConfiguration proxyConfig) throws IOException, InterruptedException {
        this.log = log;
        this.username = username;
        this.password = password;
        this.serverUrl = serverUrl;
        this.downloadSpec = downloadSpec;
        this.proxyConfig = proxyConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Dependency> invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)this.downloadSpec)) {
            return Lists.newArrayList();
        }
        SpecsHelper specsHelper = new SpecsHelper(this.log);
        ArtifactoryDependenciesClient client = new ArtifactoryDependenciesClient(this.serverUrl, this.username, this.password, this.log);
        if (this.proxyConfig != null) {
            client.setProxyConfiguration(this.proxyConfig);
        }
        try {
            List list = specsHelper.downloadArtifactsBySpec(this.downloadSpec, client, file.getCanonicalPath());
            return list;
        }
        finally {
            client.close();
        }
    }
}

