/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.build.extractor.clientConfiguration.util.EditPropertiesHelper;
import org.jfrog.build.extractor.clientConfiguration.util.spec.SpecsHelper;

public class EditPropertiesCallable
extends MasterToSlaveFileCallable<Boolean> {
    private Log log;
    private String username;
    private String password;
    private String serverUrl;
    private String spec;
    private ProxyConfiguration proxyConfig;
    private EditPropertiesHelper.EditPropertiesActionType editType;
    private String props;

    public EditPropertiesCallable(Log log, String username, String password, String serverUrl, String spec, ProxyConfiguration proxyConfig, EditPropertiesHelper.EditPropertiesActionType editType, String props) throws IOException, InterruptedException {
        this.log = log;
        this.username = username;
        this.password = password;
        this.serverUrl = serverUrl;
        this.spec = spec;
        this.proxyConfig = proxyConfig;
        this.editType = editType;
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean invoke(File file, VirtualChannel channel) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)this.spec)) {
            return false;
        }
        SpecsHelper specsHelper = new SpecsHelper(this.log);
        ArtifactoryDependenciesClient client = new ArtifactoryDependenciesClient(this.serverUrl, this.username, this.password, this.log);
        if (this.proxyConfig != null) {
            client.setProxyConfiguration(this.proxyConfig);
        }
        try {
            Boolean bl = specsHelper.editPropertiesBySpec(this.spec, client, this.editType, this.props);
            return bl;
        }
        finally {
            client.close();
        }
    }
}

