/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.generic;

import com.google.common.collect.Lists;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixConfiguration;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.XStream2;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.dependency.BuildDependency;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryDependenciesClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.BuildInfoAwareConfigurator;
import org.jfrog.hudson.BuildInfoResultAction;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.MultiConfigurationAware;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.SpecConfiguration;
import org.jfrog.hudson.action.ActionableHelper;
import org.jfrog.hudson.generic.FilesResolverCallable;
import org.jfrog.hudson.generic.GenericArtifactsDeployer;
import org.jfrog.hudson.generic.GenericArtifactsResolver;
import org.jfrog.hudson.generic.GenericBuildInfoDeployer;
import org.jfrog.hudson.release.promotion.UnifiedPromoteBuildAction;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;
import org.jfrog.hudson.util.CredentialManager;
import org.jfrog.hudson.util.Credentials;
import org.jfrog.hudson.util.FormValidations;
import org.jfrog.hudson.util.IncludesExcludes;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.RefreshServerResponse;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.jfrog.hudson.util.SpecUtils;
import org.jfrog.hudson.util.converters.DeployerResolverOverriderConverter;
import org.jfrog.hudson.util.plugins.MultiConfigurationUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ArtifactoryGenericConfigurator
extends BuildWrapper
implements DeployerOverrider,
ResolverOverrider,
BuildInfoAwareConfigurator,
MultiConfigurationAware {
    private final ServerDetails deployerDetails;
    private final ServerDetails resolverDetails;
    private final CredentialsConfig deployerCredentialsConfig;
    private final CredentialsConfig resolverCredentialsConfig;
    private final Boolean useSpecs;
    private final SpecConfiguration uploadSpec;
    private final SpecConfiguration downloadSpec;
    private final String deployPattern;
    private final String resolvePattern;
    private final String deploymentProperties;
    private final boolean deployBuildInfo;
    private final boolean includeEnvVars;
    private final IncludesExcludes envVarsPatterns;
    private final boolean discardOldBuilds;
    private final boolean discardBuildArtifacts;
    private final boolean asyncBuildRetention;
    private transient List<Dependency> publishedDependencies;
    private transient List<BuildDependency> buildDependencies;
    private String artifactoryCombinationFilter;
    private boolean multiConfProject;
    private String customBuildName;
    private boolean overrideBuildName;
    @Deprecated
    private Credentials overridingDeployerCredentials;
    @Deprecated
    private Credentials overridingResolverCredentials;
    @Deprecated
    private final ServerDetails details = null;
    @Deprecated
    private final String matrixParams;

    @DataBoundConstructor
    public ArtifactoryGenericConfigurator(ServerDetails details, ServerDetails deployerDetails, ServerDetails resolverDetails, CredentialsConfig deployerCredentialsConfig, CredentialsConfig resolverCredentialsConfig, String deployPattern, String resolvePattern, String matrixParams, String deploymentProperties, boolean useSpecs, SpecConfiguration uploadSpec, SpecConfiguration downloadSpec, boolean deployBuildInfo, boolean includeEnvVars, IncludesExcludes envVarsPatterns, boolean discardOldBuilds, boolean discardBuildArtifacts, boolean asyncBuildRetention, boolean multiConfProject, String artifactoryCombinationFilter, String customBuildName, boolean overrideBuildName) {
        this.matrixParams = null;
        this.deployerDetails = deployerDetails;
        this.resolverDetails = resolverDetails;
        this.deployerCredentialsConfig = deployerCredentialsConfig;
        this.resolverCredentialsConfig = resolverCredentialsConfig;
        this.deployPattern = deployPattern;
        this.resolvePattern = resolvePattern;
        this.useSpecs = useSpecs;
        this.uploadSpec = uploadSpec;
        this.downloadSpec = downloadSpec;
        this.deploymentProperties = deploymentProperties;
        this.deployBuildInfo = deployBuildInfo;
        this.includeEnvVars = includeEnvVars;
        this.envVarsPatterns = envVarsPatterns;
        this.discardOldBuilds = discardOldBuilds;
        this.discardBuildArtifacts = discardBuildArtifacts;
        this.asyncBuildRetention = asyncBuildRetention;
        this.multiConfProject = multiConfProject;
        this.artifactoryCombinationFilter = artifactoryCombinationFilter;
        this.customBuildName = customBuildName;
        this.overrideBuildName = overrideBuildName;
    }

    public String getArtifactoryName() {
        return this.getDeployerDetails() != null ? this.getDeployerDetails().artifactoryName : null;
    }

    public String getArtifactoryResolverName() {
        return this.resolverDetails != null ? this.resolverDetails.artifactoryName : null;
    }

    public String getArtifactoryUrl() {
        ArtifactoryServer server = this.getArtifactoryServer();
        return server != null ? server.getUrl() : null;
    }

    @Override
    public boolean isOverridingDefaultDeployer() {
        return this.deployerCredentialsConfig != null && this.deployerCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public String getRepositoryKey() {
        return this.getDeployerDetails().getDeployReleaseRepository().getRepoKey();
    }

    @Override
    public String getDefaultPromotionTargetRepository() {
        return null;
    }

    public ServerDetails getDeployerDetails() {
        return this.deployerDetails;
    }

    public ServerDetails getResolverDetails() {
        return this.resolverDetails;
    }

    @Override
    public Credentials getOverridingDeployerCredentials() {
        return this.overridingDeployerCredentials;
    }

    @Override
    public CredentialsConfig getDeployerCredentialsConfig() {
        return this.deployerCredentialsConfig;
    }

    public String getDeployPattern() {
        return this.deployPattern;
    }

    public String getResolvePattern() {
        return this.resolvePattern;
    }

    public boolean isUseSpecs() {
        return this.useSpecs == null || this.useSpecs != false;
    }

    public SpecConfiguration getUploadSpec() {
        return this.uploadSpec;
    }

    public SpecConfiguration getDownloadSpec() {
        return this.downloadSpec;
    }

    public String getDeploymentProperties() {
        return this.deploymentProperties;
    }

    public boolean isDeployBuildInfo() {
        return this.deployBuildInfo;
    }

    @Override
    public boolean isIncludeEnvVars() {
        return this.includeEnvVars;
    }

    @Override
    public IncludesExcludes getEnvVarsPatterns() {
        return this.envVarsPatterns;
    }

    @Override
    public boolean isDiscardOldBuilds() {
        return this.discardOldBuilds;
    }

    @Override
    public boolean isDiscardBuildArtifacts() {
        return this.discardBuildArtifacts;
    }

    @Override
    public boolean isAsyncBuildRetention() {
        return this.asyncBuildRetention;
    }

    @Override
    public boolean isEnableIssueTrackerIntegration() {
        return false;
    }

    @Override
    public boolean isAggregateBuildIssues() {
        return false;
    }

    @Override
    public String getAggregationBuildStatus() {
        return null;
    }

    @Override
    public String getArtifactoryCombinationFilter() {
        return this.artifactoryCombinationFilter;
    }

    @Override
    public boolean isMultiConfProject() {
        return this.multiConfProject;
    }

    @Override
    public String getCustomBuildName() {
        return this.customBuildName;
    }

    @Override
    public boolean isOverrideBuildName() {
        return this.overrideBuildName;
    }

    @Override
    public ArtifactoryServer getArtifactoryServer() {
        return RepositoriesUtils.getArtifactoryServer(this.getArtifactoryName(), this.getDescriptor().getArtifactoryServers());
    }

    public ArtifactoryServer getArtifactoryResolverServer() {
        String serverId = this.getArtifactoryResolverName();
        if (serverId == null) {
            throw new RuntimeException("Artifactory server for dependencies resolution is null");
        }
        ArtifactoryServer server = RepositoriesUtils.getArtifactoryServer(serverId, this.getDescriptor().getArtifactoryServers());
        if (server == null) {
            throw new RuntimeException(String.format("The job is configured to use an Artifactory server with ID '%s' for dependencies resolution. This server however does not exist", serverId));
        }
        return server;
    }

    public List<Repository> getReleaseRepositoryList() {
        if (this.getDeployerDetails().getDeploySnapshotRepository() == null) {
            return Lists.newArrayList();
        }
        return RepositoriesUtils.collectRepositories(this.getDeployerDetails().getDeploySnapshotRepository().getKeyFromSelect());
    }

    public Collection<? extends Action> getProjectActions(AbstractProject project) {
        if (this.isOverrideBuildName()) {
            return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project, this.getCustomBuildName());
        }
        return ActionableHelper.getArtifactoryProjectAction(this.getArtifactoryName(), project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Jenkins Artifactory Plugin version: " + ActionableHelper.getArtifactoryPluginVersion());
        RepositoriesUtils.validateServerConfig(build, listener, this.getArtifactoryServer(), this.getArtifactoryUrl());
        if (StringUtils.isBlank((String)this.getArtifactoryName())) {
            return super.setUp(build, launcher, listener);
        }
        ArtifactoryServer resolverServer = this.getArtifactoryResolverServer();
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(this, resolverServer);
        String username = preferredResolver.provideUsername((Item)build.getProject());
        String password = preferredResolver.providePassword((Item)build.getProject());
        ProxyConfiguration proxyConfiguration = null;
        hudson.ProxyConfiguration proxy = Jenkins.getInstance().proxy;
        if (proxy != null && !resolverServer.isBypassProxy()) {
            proxyConfiguration = ArtifactoryServer.createProxyConfiguration(proxy);
        }
        try (ArtifactoryDependenciesClient dependenciesClient = null;){
            GenericArtifactsResolver artifactsResolver;
            if (this.isUseSpecs()) {
                String spec = SpecUtils.getSpecStringFromSpecConf(this.downloadSpec, build.getEnvironment((TaskListener)listener), build.getExecutor().getCurrentWorkspace(), listener.getLogger());
                FilePath workspace = build.getExecutor().getCurrentWorkspace();
                this.publishedDependencies = (List)workspace.act((FilePath.FileCallable)new FilesResolverCallable(new JenkinsBuildInfoLog((TaskListener)listener), username, password, resolverServer.getUrl(), spec, proxyConfiguration));
            } else {
                dependenciesClient = resolverServer.createArtifactoryDependenciesClient(username, password, proxyConfiguration, (TaskListener)listener);
                artifactsResolver = new GenericArtifactsResolver(build, listener, dependenciesClient);
                this.publishedDependencies = artifactsResolver.retrievePublishedDependencies(this.resolvePattern);
                this.buildDependencies = artifactsResolver.retrieveBuildDependencies(this.resolvePattern);
            }
            artifactsResolver = this.createEnvironmentOnSuccessfulSetup();
            return artifactsResolver;
        }
        return null;
    }

    private BuildWrapper.Environment createEnvironmentOnSuccessfulSetup() {
        return new BuildWrapper.Environment(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean tearDown(AbstractBuild build, BuildListener listener) {
                Result result = build.getResult();
                if (result != null && result.isWorseThan(Result.SUCCESS)) {
                    return true;
                }
                ArtifactoryServer server = ArtifactoryGenericConfigurator.this.getArtifactoryServer();
                CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(ArtifactoryGenericConfigurator.this, server);
                server.setLog((TaskListener)listener, (ArtifactoryBaseClient)client);
                try (ArtifactoryBuildInfoClient client = server.createArtifactoryClient(preferredDeployer.provideUsername((Item)build.getProject()), preferredDeployer.providePassword((Item)build.getProject()), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy));){
                    boolean isFiltered = false;
                    if (ArtifactoryGenericConfigurator.this.isMultiConfProject(build)) {
                        if (ArtifactoryGenericConfigurator.this.multiConfProject && StringUtils.isBlank((String)ArtifactoryGenericConfigurator.this.getArtifactoryCombinationFilter())) {
                            String error = "The field \"Combination Matches\" is empty, but is defined as mandatory!";
                            listener.getLogger().println(error);
                            build.setResult(Result.FAILURE);
                            throw new IllegalArgumentException(error);
                        }
                        isFiltered = MultiConfigurationUtils.isfiltrated(build, ArtifactoryGenericConfigurator.this.getArtifactoryCombinationFilter());
                    }
                    if (!isFiltered) {
                        GenericArtifactsDeployer artifactsDeployer = new GenericArtifactsDeployer((Run)build, ArtifactoryGenericConfigurator.this, listener, preferredDeployer);
                        artifactsDeployer.deploy();
                        List<Artifact> deployedArtifacts = artifactsDeployer.getDeployedArtifacts();
                        if (ArtifactoryGenericConfigurator.this.deployBuildInfo) {
                            new GenericBuildInfoDeployer(ArtifactoryGenericConfigurator.this, client, (Run)build, (TaskListener)listener, deployedArtifacts, ArtifactoryGenericConfigurator.this.buildDependencies, ArtifactoryGenericConfigurator.this.publishedDependencies).deploy();
                            String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(ArtifactoryGenericConfigurator.this, (Run)build);
                            build.getActions().add(0, new BuildInfoResultAction(ArtifactoryGenericConfigurator.this.getArtifactoryUrl(), (Run)build, buildName));
                            build.getActions().add(new UnifiedPromoteBuildAction((Run)build, ArtifactoryGenericConfigurator.this));
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                build.setResult(Result.FAILURE);
                return true;
            }
        };
    }

    private boolean isMultiConfProject(AbstractBuild build) {
        return build.getProject().getClass().equals(MatrixConfiguration.class);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Override
    public boolean isOverridingDefaultResolver() {
        return this.resolverCredentialsConfig != null && this.resolverCredentialsConfig.isCredentialsProvided();
    }

    @Override
    public Credentials getOverridingResolverCredentials() {
        return this.overridingResolverCredentials;
    }

    @Override
    public CredentialsConfig getResolverCredentialsConfig() {
        return this.resolverCredentialsConfig;
    }

    public static final class ConverterImpl
    extends DeployerResolverOverriderConverter {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        private List<Repository> releaseRepositories;
        private AbstractProject<?, ?> item;

        public DescriptorImpl() {
            super(ArtifactoryGenericConfigurator.class);
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            this.item = item;
            return item.getClass().isAssignableFrom(FreeStyleProject.class) || item.getClass().isAssignableFrom(MatrixProject.class) || Jenkins.getInstance().getPlugin("jenkins-multijob-plugin") != null && item.getClass().isAssignableFrom(MultiJobProject.class);
        }

        @JavaScriptMethod
        public RefreshServerResponse refreshFromArtifactory(String url, String credentialsId, String username, String password, boolean overrideCredentials) {
            RefreshServerResponse response = new RefreshServerResponse();
            CredentialsConfig credentialsConfig = new CredentialsConfig(username, password, credentialsId, overrideCredentials);
            ArtifactoryServer artifactoryServer = RepositoriesUtils.getArtifactoryServer(url, RepositoriesUtils.getArtifactoryServers());
            try {
                List<String> releaseRepositoryKeysFirst = RepositoriesUtils.getLocalRepositories(url, credentialsConfig, artifactoryServer, this.item);
                Collections.sort(releaseRepositoryKeysFirst);
                this.releaseRepositories = RepositoriesUtils.createRepositoriesList(releaseRepositoryKeysFirst);
                response.setRepositories(this.releaseRepositories);
                response.setSuccess(true);
            }
            catch (Exception e) {
                response.setResponseMessage(e.getMessage());
                response.setSuccess(false);
            }
            return response;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item project) {
            return PluginsUtils.fillPluginCredentials(project);
        }

        public String getDisplayName() {
            return "Generic-Artifactory Integration";
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            req.bindParameters((Object)this, "generic");
            this.save();
            return true;
        }

        public boolean isMultiConfProject() {
            return this.item.getClass().isAssignableFrom(MatrixProject.class);
        }

        public FormValidation doCheckArtifactoryCombinationFilter(@QueryParameter String value) throws IOException, InterruptedException {
            return FormValidations.validateArtifactoryCombinationFilter(value);
        }

        public List<ArtifactoryServer> getArtifactoryServers() {
            return RepositoriesUtils.getArtifactoryServers();
        }

        public boolean isUseCredentialsPlugin() {
            return PluginsUtils.isUseCredentialsPlugin();
        }
    }
}

