/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class RepositoryConf {
    private final String keyFromText;
    private final String keyFromSelect;
    private final boolean dynamicMode;
    public static final RepositoryConf emptyRepositoryConfig = new RepositoryConf("", "", false);

    @DataBoundConstructor
    public RepositoryConf(String keyFromText, String keyFromSelect, boolean dynamicMode) {
        this.keyFromText = keyFromText;
        this.keyFromSelect = keyFromSelect;
        this.dynamicMode = dynamicMode;
    }

    public String getRepoKey() {
        String repoKey = this.isDynamicMode() ? this.keyFromText : this.keyFromSelect;
        return repoKey;
    }

    public String getRepoName() {
        return this.getRepoKey();
    }

    public String getKeyFromText() {
        return this.keyFromText;
    }

    public String getKeyFromSelect() {
        return this.keyFromSelect;
    }

    public boolean isDynamicMode() {
        return this.dynamicMode || StringUtils.isBlank((String)this.keyFromSelect) && StringUtils.isNotBlank((String)this.keyFromText);
    }
}

