/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson;

import hudson.Util;
import hudson.model.BuildBadgeAction;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.Build;
import org.jfrog.hudson.ArtifactoryRedeployPublisher;
import org.jfrog.hudson.PublishedBuildDetails;
import org.jfrog.hudson.util.BuildUniqueIdentifierHelper;

public class BuildInfoResultAction
implements BuildBadgeAction {
    private List<PublishedBuildDetails> publishedBuildsDetails = new ArrayList<PublishedBuildDetails>();
    private final Run build;
    @Deprecated
    private String url;
    @Deprecated
    private transient ArtifactoryRedeployPublisher artifactoryRedeployPublisher;

    public BuildInfoResultAction(Run build) {
        this.build = build;
    }

    public BuildInfoResultAction(String artifactoryUrl, Run build, String buildName) {
        this(build);
        String buildNumber = BuildUniqueIdentifierHelper.getBuildNumber(build);
        this.publishedBuildsDetails.add(this.createBuildInfoIdentifier(artifactoryUrl, buildName, buildNumber));
    }

    public void addBuildInfoResults(String artifactoryUrl, Build buildInfo) {
        this.publishedBuildsDetails.add(this.createBuildInfoIdentifier(artifactoryUrl, this.build, buildInfo));
    }

    public Run getBuild() {
        return this.build;
    }

    public String getIconFileName() {
        return "/plugin/artifactory/images/artifactory-icon.png";
    }

    public String getDisplayName() {
        return "Artifactory Build Info";
    }

    public String getUrlName() {
        if (StringUtils.isNotEmpty((String)this.url)) {
            return this.url;
        }
        if (this.publishedBuildsDetails == null) {
            this.publishedBuildsDetails = new ArrayList<PublishedBuildDetails>();
        }
        if (this.publishedBuildsDetails.size() == 0 && this.artifactoryRedeployPublisher != null && this.build != null) {
            String buildName = BuildUniqueIdentifierHelper.getBuildNameConsiderOverride(this.artifactoryRedeployPublisher, this.build);
            return this.generateUrl(this.artifactoryRedeployPublisher.getArtifactoryName(), this.build, buildName);
        }
        if (this.publishedBuildsDetails.size() == 1) {
            return this.publishedBuildsDetails.get(0).getBuildInfoUrl();
        }
        return "published_builds";
    }

    private PublishedBuildDetails createBuildInfoIdentifier(String artifactoryUrl, String buildName, String buildNumber) {
        return new PublishedBuildDetails(artifactoryUrl, Util.rawEncode((String)buildName), Util.rawEncode((String)buildNumber));
    }

    private PublishedBuildDetails createBuildInfoIdentifier(String artifactoryUrl, Run build, Build buildInfo) {
        String buildName = StringUtils.isNotEmpty((String)buildInfo.getName()) ? buildInfo.getName() : BuildUniqueIdentifierHelper.getBuildName(build);
        String buildNumber = StringUtils.isNotEmpty((String)buildInfo.getNumber()) ? buildInfo.getNumber() : BuildUniqueIdentifierHelper.getBuildNumber(build);
        return this.createBuildInfoIdentifier(artifactoryUrl, buildName, buildNumber);
    }

    private String generateUrl(String artifactoryUrl, Run build, String buildName) {
        return artifactoryUrl + "/webapp/builds/" + Util.rawEncode((String)buildName) + "/" + Util.rawEncode((String)BuildUniqueIdentifierHelper.getBuildNumber(build));
    }

    public boolean haveMultipleBuilds() {
        return this.publishedBuildsDetails != null && this.publishedBuildsDetails.size() > 1;
    }

    public List<PublishedBuildDetails> getPublishedBuildsDetails() {
        return this.publishedBuildsDetails;
    }

    @Deprecated
    public void setUrl(String url) {
        this.url = url;
    }
}

