/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.plugins;

import hudson.matrix.Combination;
import hudson.matrix.MatrixConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;

public class MultiConfigurationUtils {
    public static void validateCombinationFilter(AbstractBuild build, BuildListener listener, String combFilter) {
        if (StringUtils.isBlank((String)combFilter)) {
            String error = "The \"Combination Matches\" field is mandatory. It cannot be empty.";
            listener.getLogger().println(error);
            build.setResult(Result.FAILURE);
            throw new IllegalArgumentException(error);
        }
    }

    public static boolean isfiltrated(AbstractBuild build, String combinationFilter) {
        if (StringUtils.isEmpty((String)combinationFilter)) {
            return true;
        }
        if (build.getProject() instanceof MatrixConfiguration) {
            MatrixConfiguration matrixConf = (MatrixConfiguration)build.getProject();
            return !matrixConf.getCombination().evalGroovyExpression(matrixConf.getParent().getAxes(), combinationFilter);
        }
        return false;
    }

    public static void addMatrixCombination(Run<?, ?> build, ArtifactoryClientConfiguration configuration) {
        if (build.getParent() instanceof MatrixConfiguration) {
            Combination combination = ((MatrixConfiguration)build.getParent()).getCombination();
            for (Map.Entry entries : combination.entrySet()) {
                configuration.info.addRunParameters((String)entries.getKey(), (String)entries.getValue());
            }
        }
    }
}

