/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util.converters;

import com.google.common.collect.Lists;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.util.XStream2;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jfrog.hudson.RepositoryConf;
import org.jfrog.hudson.ServerDetails;

public class ServerDetailsConverter
extends XStream2.PassthruConverter<ServerDetails> {
    Logger logger = Logger.getLogger(ServerDetailsConverter.class.getName());
    List<String> converterErrors = Lists.newArrayList();
    private static final Map<String, String> newToOldFields = new HashMap<String, String>();

    public ServerDetailsConverter(XStream2 xstream) {
        super(xstream);
    }

    public void convertToReleaseAndSnapshotRepository(ServerDetails server) {
        Class<?> overrideClass = server.getClass();
        try {
            Field oldReleaseRepositoryField = overrideClass.getDeclaredField("downloadRepositoryKey");
            oldReleaseRepositoryField.setAccessible(true);
            Object oldReleaseRepositoryValue = oldReleaseRepositoryField.get(server);
            if (oldReleaseRepositoryValue != null && StringUtils.isNotBlank((String)((String)oldReleaseRepositoryValue))) {
                Field newReleaseRepositoryField = overrideClass.getDeclaredField("downloadReleaseRepositoryKey");
                newReleaseRepositoryField.setAccessible(true);
                newReleaseRepositoryField.set(server, oldReleaseRepositoryValue);
                Field newSnapshotRepositoryField = overrideClass.getDeclaredField("downloadSnapshotRepositoryKey");
                newSnapshotRepositoryField.setAccessible(true);
                newSnapshotRepositoryField.set(server, oldReleaseRepositoryValue);
            }
        }
        catch (NoSuchFieldException e) {
            this.converterErrors.add(this.getConversionErrorMessage(server, e));
        }
        catch (IllegalAccessException e) {
            this.converterErrors.add(this.getConversionErrorMessage(server, e));
        }
    }

    public void convertToDynamicReposSelection(ServerDetails server) {
        Class<?> overrideClass = server.getClass();
        for (Map.Entry<String, String> e : newToOldFields.entrySet()) {
            this.setNewReposFieldFromOld(server, overrideClass, e.getKey(), e.getValue());
        }
    }

    private void setNewReposFieldFromOld(ServerDetails reflectedObject, Class classToChange, String oldFieldName, String newFieldName) {
        try {
            Field oldField = classToChange.getDeclaredField(oldFieldName);
            oldField.setAccessible(true);
            String oldValue = (String)oldField.get(reflectedObject);
            if (StringUtils.isNotBlank((String)oldValue)) {
                Field newField = classToChange.getDeclaredField(newFieldName);
                RepositoryConf newValue = new RepositoryConf(oldValue, oldValue, false);
                newField.setAccessible(true);
                newField.set(reflectedObject, newValue);
            }
        }
        catch (NoSuchFieldException e) {
            this.converterErrors.add(this.getConversionErrorMessage(reflectedObject, e));
        }
        catch (IllegalAccessException e) {
            this.converterErrors.add(this.getConversionErrorMessage(reflectedObject, e));
        }
    }

    protected void callback(ServerDetails server, UnmarshallingContext context) {
        this.convertToReleaseAndSnapshotRepository(server);
        this.convertToDynamicReposSelection(server);
        if (!this.converterErrors.isEmpty()) {
            this.logger.info(this.converterErrors.toString());
        }
    }

    private String getConversionErrorMessage(ServerDetails serverDetails, Exception e) {
        return String.format("Could not convert the class '%s' to use the new overriding Resolve repositories. Cause: %s", serverDetails.getClass().getName(), e.getCause());
    }

    static {
        newToOldFields.put("repositoryKey", "deployReleaseRepository");
        newToOldFields.put("snapshotsRepositoryKey", "deploySnapshotRepository");
        newToOldFields.put("downloadSnapshotRepositoryKey", "resolveSnapshotRepository");
        newToOldFields.put("downloadReleaseRepositoryKey", "resolveReleaseRepository");
    }
}

