/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import hudson.ProxyConfiguration;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Result;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBaseClient;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryBuilder;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.Repository;
import org.jfrog.hudson.ResolverOverrider;
import org.jfrog.hudson.VirtualRepository;
import org.jfrog.hudson.util.CredentialManager;

public abstract class RepositoriesUtils {
    public static List<String> getReleaseRepositoryKeysFirst(DeployerOverrider deployer, ArtifactoryServer server) throws IOException {
        if (server == null) {
            return Lists.newArrayList();
        }
        return server.getReleaseRepositoryKeysFirst(deployer, null);
    }

    public static List<String> getSnapshotRepositoryKeysFirst(DeployerOverrider deployer, ArtifactoryServer server) throws IOException {
        if (server == null) {
            return Lists.newArrayList();
        }
        return server.getSnapshotRepositoryKeysFirst(deployer, null);
    }

    public static List<VirtualRepository> getVirtualRepositoryKeys(ResolverOverrider resolverOverrider, DeployerOverrider deployerOverrider, ArtifactoryServer server) {
        if (server == null) {
            return Lists.newArrayList();
        }
        return server.getVirtualRepositoryKeys(resolverOverrider, null);
    }

    public static List<VirtualRepository> generateVirtualRepos(ArtifactoryBuildInfoClient client) throws IOException {
        List keys = client.getVirtualRepositoryKeys();
        ArrayList virtualRepositories = Lists.newArrayList((Iterable)Lists.transform((List)keys, (Function)new Function<String, VirtualRepository>(){

            public VirtualRepository apply(String from) {
                return new VirtualRepository(from, from);
            }
        }));
        return virtualRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VirtualRepository> getVirtualRepositoryKeys(String url, CredentialsConfig credentialsConfig, ArtifactoryServer artifactoryServer, Item item) throws IOException {
        CredentialsConfig preferredResolver = CredentialManager.getPreferredResolver(credentialsConfig, artifactoryServer);
        try (ArtifactoryBuildInfoClient client = StringUtils.isNotBlank((String)preferredResolver.provideUsername(item)) ? new ArtifactoryBuildInfoClient(url, preferredResolver.provideUsername(item), preferredResolver.providePassword(item), (Log)new NullLog()) : new ArtifactoryBuildInfoClient(url, (Log)new NullLog());){
            List<VirtualRepository> virtualRepositories;
            client.setConnectionTimeout(artifactoryServer.getTimeout());
            RepositoriesUtils.setRetryParams(artifactoryServer, client);
            if (Jenkins.getInstance().proxy != null && !artifactoryServer.isBypassProxy()) {
                client.setProxyConfiguration(RepositoriesUtils.createProxyConfiguration(Jenkins.getInstance().proxy));
            }
            List<VirtualRepository> list = virtualRepositories = RepositoriesUtils.generateVirtualRepos(client);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getLocalRepositories(String url, CredentialsConfig credentialsConfig, ArtifactoryServer artifactoryServer, Item item) throws IOException {
        CredentialsConfig preferredDeployer = CredentialManager.getPreferredDeployer(credentialsConfig, artifactoryServer);
        try (ArtifactoryBuildInfoClient client = StringUtils.isNotBlank((String)preferredDeployer.provideUsername(item)) ? new ArtifactoryBuildInfoClient(url, preferredDeployer.provideUsername(item), preferredDeployer.providePassword(item), (Log)new NullLog()) : new ArtifactoryBuildInfoClient(url, (Log)new NullLog());){
            List localRepository;
            client.setConnectionTimeout(artifactoryServer.getTimeout());
            RepositoriesUtils.setRetryParams(artifactoryServer, client);
            if (Jenkins.getInstance().proxy != null && !artifactoryServer.isBypassProxy()) {
                client.setProxyConfiguration(RepositoriesUtils.createProxyConfiguration(Jenkins.getInstance().proxy));
            }
            List list = localRepository = client.getLocalRepositoriesKeys();
            return list;
        }
    }

    public static org.jfrog.build.client.ProxyConfiguration createProxyConfiguration(ProxyConfiguration proxy) {
        org.jfrog.build.client.ProxyConfiguration proxyConfiguration = null;
        if (proxy != null) {
            proxyConfiguration = new org.jfrog.build.client.ProxyConfiguration();
            proxyConfiguration.host = proxy.name;
            proxyConfiguration.port = proxy.port;
            proxyConfiguration.username = proxy.getUserName();
            proxyConfiguration.password = proxy.getPassword();
        }
        return proxyConfiguration;
    }

    public static ArtifactoryServer getArtifactoryServer(String artifactoryIdentity, List<ArtifactoryServer> artifactoryServers) {
        if (artifactoryServers != null) {
            for (ArtifactoryServer server : artifactoryServers) {
                if (!server.getUrl().equals(artifactoryIdentity) && !server.getName().equals(artifactoryIdentity)) continue;
                return server;
            }
        }
        return null;
    }

    public static List<ArtifactoryServer> getArtifactoryServers() {
        ArtifactoryBuilder.DescriptorImpl descriptor = (ArtifactoryBuilder.DescriptorImpl)Hudson.getInstance().getDescriptor(ArtifactoryBuilder.class);
        return descriptor.getArtifactoryServers();
    }

    public static List<Repository> createRepositoriesList(List<String> repositoriesValueList) {
        ArrayList repositories = Lists.newArrayList();
        for (String repositoryKey : repositoriesValueList) {
            Repository repository = new Repository(repositoryKey);
            repositories.add(repository);
        }
        return repositories;
    }

    public static List<VirtualRepository> collectVirtualRepositories(List<VirtualRepository> repositories, String repoKey) {
        if (repositories == null) {
            repositories = Lists.newArrayList();
        }
        if (StringUtils.isNotBlank((String)repoKey)) {
            for (VirtualRepository vr : repositories) {
                if (!repoKey.equals(vr.getDisplayName())) continue;
                return repositories;
            }
            VirtualRepository vr = new VirtualRepository(repoKey, repoKey);
            repositories.add(vr);
        }
        return repositories;
    }

    public static List<Repository> collectRepositories(String repoKey) {
        ArrayList repositories = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)repoKey)) {
            Repository r = new Repository(repoKey);
            repositories.add(r);
        }
        return repositories;
    }

    public static void validateServerConfig(AbstractBuild build, BuildListener listener, ArtifactoryServer artifactoryServer, String artifactoryUrl) throws IOException {
        if (artifactoryServer == null) {
            String error = "No Artifactory server configured for " + artifactoryUrl + ". Please check your configuration.";
            listener.getLogger().println(error);
            build.setResult(Result.FAILURE);
            throw new IOException(error);
        }
    }

    private static void setRetryParams(ArtifactoryServer artifactoryServer, ArtifactoryBuildInfoClient client) {
        RepositoriesUtils.setRetryParams(artifactoryServer.getConnectionRetry(), (ArtifactoryBaseClient)client);
    }

    public static void setRetryParams(int connectionRetry, ArtifactoryBaseClient client) {
        client.setConnectionRetries(connectionRetry);
    }
}

