/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class PropertyUtils {
    private static final Logger debuggingLogger = Logger.getLogger(PropertyUtils.class.getName());

    private PropertyUtils() {
        throw new IllegalAccessError();
    }

    public static Map<String, String> getModulesPropertiesFromPropFile(FilePath gradlePropPath, String[] propKeys) throws IOException, InterruptedException {
        Properties gradleProps = PropertyUtils.loadGradleProperties(gradlePropPath);
        LinkedHashMap versionsByPropKey = Maps.newLinkedHashMap();
        for (String propKey : propKeys) {
            if (!gradleProps.containsKey(propKey)) continue;
            versionsByPropKey.put(propKey, gradleProps.getProperty(propKey));
        }
        return versionsByPropKey;
    }

    private static Properties loadGradleProperties(FilePath gradlePropertiesFilePath) throws IOException, InterruptedException {
        return (Properties)gradlePropertiesFilePath.act((FilePath.FileCallable)new MasterToSlaveFileCallable<Properties>(){

            public Properties invoke(File gradlePropertiesFile, VirtualChannel channel) throws IOException, InterruptedException {
                Properties gradleProps = new Properties();
                if (gradlePropertiesFile.exists()) {
                    debuggingLogger.fine("Gradle properties file exists at: " + gradlePropertiesFile.getAbsolutePath());
                    FileInputStream stream = null;
                    try {
                        stream = new FileInputStream(gradlePropertiesFile);
                        gradleProps.load(stream);
                    }
                    catch (IOException e) {
                        try {
                            debuggingLogger.fine("IO exception occurred while trying to read properties file from: " + gradlePropertiesFile.getAbsolutePath());
                            throw new RuntimeException(e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(stream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)stream);
                }
                return gradleProps;
            }
        });
    }

    public static Multimap<String, String> getDeploymentPropertiesMap(String propertiesStr, EnvVars env) {
        ArrayListMultimap properties = ArrayListMultimap.create();
        String[] deploymentProperties = StringUtils.split((String)propertiesStr, (String)";");
        if (deploymentProperties == null) {
            return properties;
        }
        for (String property : deploymentProperties) {
            String[] split = StringUtils.split((String)property, (char)'=');
            if (split.length != 2) continue;
            String value = Util.replaceMacro((String)split[1], (Map)env);
            properties.put((Object)split[0].replace(" ", ""), (Object)value);
        }
        return properties;
    }
}

