/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Hudson;
import hudson.remoting.Which;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.BuildInfoExtractor;

public class PluginDependencyHelper {
    public static FilePath getActualDependencyDirectory(File localDependencyFile, FilePath rootPath) throws IOException, InterruptedException {
        FilePath remoteDependencyMark;
        FilePath remoteDependencyDir;
        File localDependencyDir = localDependencyFile.getParentFile();
        String pluginVersion = Hudson.getInstance().getPluginManager().getPlugin("artifactory").getVersion();
        if (pluginVersion.contains(" ")) {
            pluginVersion = StringUtils.split((String)pluginVersion, (String)" ")[0];
        }
        if (!(remoteDependencyDir = new FilePath(rootPath, "cache/artifactory-plugin/" + pluginVersion)).exists()) {
            remoteDependencyDir.mkdirs();
        }
        if (!(remoteDependencyMark = new FilePath(remoteDependencyDir, "ok")).exists()) {
            File[] localDependencies;
            for (File localDependency : localDependencies = localDependencyDir.listFiles()) {
                FilePath remoteDependencyFilePath;
                if (localDependency.getName().equals("classes.jar") || (remoteDependencyFilePath = new FilePath(remoteDependencyDir, localDependency.getName())).exists()) continue;
                FilePath localDependencyFilePath = new FilePath(localDependency);
                localDependencyFilePath.copyTo(remoteDependencyFilePath);
            }
            remoteDependencyMark.touch(System.currentTimeMillis());
        }
        return remoteDependencyDir;
    }

    public static File getExtractorJar(EnvVars env) throws IOException {
        String libPath = (String)env.get((Object)"ARTIFACTORY_JARS_LIB");
        if (StringUtils.isBlank((String)libPath)) {
            return Which.jarFile(BuildInfoExtractor.class);
        }
        WildcardFileFilter fileFilter = new WildcardFileFilter("build-info-extractor-*.jar");
        Object[] jars = new File(libPath).listFiles((FileFilter)fileFilter);
        if (ArrayUtils.isEmpty((Object[])jars)) {
            throw new IOException("Artifactory jars lib util doesn't contain the build info extractors");
        }
        return jars[0];
    }
}

