/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.util.Scrambler;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class Credentials
implements Serializable {
    public static final Credentials EMPTY_CREDENTIALS = new Credentials("", "");
    private final String username;
    private final String password;

    public Credentials(String username, String password) {
        this.username = username;
        this.password = Scrambler.scramble((String)password);
    }

    @DataBoundConstructor
    public Credentials(String username, String password, String resolverUsername, String resolverPassword) {
        if (StringUtils.isNotBlank((String)resolverUsername) && StringUtils.isNotBlank((String)resolverPassword)) {
            username = resolverUsername;
            password = resolverPassword;
        }
        this.username = username;
        this.password = Scrambler.scramble((String)password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return Scrambler.descramble((String)this.password);
    }
}

