/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.DeployerOverrider;
import org.jfrog.hudson.ResolverOverrider;

public abstract class CredentialManager {
    private CredentialManager() {
    }

    public static CredentialsConfig getPreferredDeployer(DeployerOverrider deployerOverrider, ArtifactoryServer server) {
        CredentialsConfig deployerCredentials;
        CredentialsConfig deployerCredentialsConfig;
        if (deployerOverrider.isOverridingDefaultDeployer() && (deployerCredentialsConfig = deployerOverrider.getDeployerCredentialsConfig()) != null) {
            return deployerCredentialsConfig;
        }
        if (server != null && (deployerCredentials = server.getDeployerCredentialsConfig()) != null) {
            return deployerCredentials;
        }
        return CredentialsConfig.EMPTY_CREDENTIALS_CONFIG;
    }

    public static CredentialsConfig getPreferredDeployer(CredentialsConfig credentialsConfig, ArtifactoryServer server) {
        if (!credentialsConfig.isCredentialsProvided()) {
            return server.getDeployerCredentialsConfig();
        }
        return credentialsConfig;
    }

    public static CredentialsConfig getPreferredResolver(ResolverOverrider resolverOverrider, ArtifactoryServer server) {
        CredentialsConfig resolverCredentialsConfig;
        if (resolverOverrider != null && resolverOverrider.isOverridingDefaultResolver() && (resolverCredentialsConfig = resolverOverrider.getResolverCredentialsConfig()) != null) {
            return resolverCredentialsConfig;
        }
        return server.getResolvingCredentialsConfig();
    }

    public static CredentialsConfig getPreferredResolver(CredentialsConfig credentialsConfig, ArtifactoryServer server) {
        if (!credentialsConfig.isCredentialsProvided()) {
            return server.getResolvingCredentialsConfig();
        }
        return credentialsConfig;
    }
}

