/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import hudson.model.Run;
import hudson.tasks.LogRotator;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jenkins.model.BuildDiscarder;
import org.jfrog.build.api.BuildRetention;
import org.jfrog.hudson.util.ExtractorUtils;

public class BuildRetentionFactory {
    public static BuildRetention createBuildRetention(Run build, boolean discardOldArtifacts) {
        BuildRetention buildRetention = new BuildRetention(discardOldArtifacts);
        LogRotator rotator = null;
        BuildDiscarder buildDiscarder = build.getParent().getBuildDiscarder();
        if (buildDiscarder != null && buildDiscarder instanceof LogRotator) {
            rotator = (LogRotator)buildDiscarder;
        }
        if (rotator == null) {
            return buildRetention;
        }
        if (rotator.getNumToKeep() > -1) {
            buildRetention.setCount(rotator.getNumToKeep());
        }
        if (rotator.getDaysToKeep() > -1) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -rotator.getDaysToKeep());
            buildRetention.setMinimumBuildDate(new Date(calendar.getTimeInMillis()));
        }
        List<String> notToBeDeleted = ExtractorUtils.getBuildNumbersNotToBeDeleted(build);
        buildRetention.setBuildNumbersNotToBeDiscarded(notToBeDeleted);
        return buildRetention;
    }
}

