/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.trigger;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Project;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.api.util.NullLog;
import org.jfrog.build.client.ItemLastModified;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.ArtifactoryServer;
import org.jfrog.hudson.ServerDetails;
import org.jfrog.hudson.trigger.ArtifactoryCause;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.jfrog.hudson.util.RepositoriesUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArtifactoryTrigger
extends Trigger {
    private static final Logger logger = Logger.getLogger(JenkinsBuildInfoLog.class.getName());
    private String path;
    private ServerDetails details;
    private long lastModified = System.currentTimeMillis();

    @DataBoundConstructor
    public ArtifactoryTrigger(String path, String spec, ServerDetails details) throws ANTLRException {
        super(spec);
        this.path = path;
        this.details = details;
    }

    public void run() {
        if (this.job == null) {
            return;
        }
        ArtifactoryServer server = RepositoriesUtils.getArtifactoryServer(this.details.getArtifactoryName(), RepositoriesUtils.getArtifactoryServers());
        if (server == null) {
            logger.warning("Artifactory Trigger failed triggering the job, since Artifactory server " + this.details.getArtifactoryName() + " does not exist.");
            return;
        }
        try (ArtifactoryBuildInfoClient client = server.createArtifactoryClient(server.getDeployerCredentialsConfig().provideUsername(this.job), server.getDeployerCredentialsConfig().providePassword(this.job), ArtifactoryServer.createProxyConfiguration(Jenkins.getInstance().proxy), (Log)new NullLog());){
            ItemLastModified itemLastModified = client.getItemLastModified(this.path);
            long responseLastModified = itemLastModified.getLastModified();
            if (responseLastModified > this.lastModified) {
                this.lastModified = responseLastModified;
                if (this.job instanceof Project) {
                    AbstractProject project = ((Project)this.job).getRootProject();
                    this.saveAndSchedule(itemLastModified, project);
                    return;
                }
                if (this.job instanceof MavenModuleSet) {
                    AbstractProject project = ((MavenModuleSet)this.job).getRootProject();
                    this.saveAndSchedule(itemLastModified, project);
                    return;
                }
                if (this.job instanceof WorkflowJob) {
                    WorkflowJob project = (WorkflowJob)this.job;
                    logger.fine("Updating " + this.job.getName());
                    project.save();
                    project.scheduleBuild((Cause)new ArtifactoryCause(itemLastModified.getUri()));
                }
            } else {
                logger.fine(String.format("Artifactory trigger did not trigger job %s, since last modified time: %d is earlier or equal than %d for path %s", this.job.getName(), responseLastModified, this.lastModified, this.path));
            }
        }
        catch (IOException | ParseException e) {
            logger.severe("Received an error: " + e.getMessage());
            logger.fine("Received an error: " + e);
        }
    }

    private void saveAndSchedule(ItemLastModified itemLastModified, AbstractProject project) throws IOException {
        logger.fine("Updating " + this.job.getName());
        project.save();
        project.scheduleBuild((Cause)new ArtifactoryCause(itemLastModified.getUri()));
    }

    public void stop() {
        if (this.job != null) {
            logger.info("Stopping " + this.job.getName() + " Artifactory trigger.");
        }
        super.stop();
    }

    public String getPath() {
        return this.path;
    }

    public ServerDetails getDetails() {
        return this.details;
    }

    public String getArtifactoryName() {
        return this.getDetails() != null ? this.getDetails().artifactoryName : null;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends TriggerDescriptor {
        public String getDisplayName() {
            return "Enable Artifactory trigger";
        }

        public boolean isApplicable(Item item) {
            return item instanceof WorkflowJob || item instanceof Project || item instanceof MavenModuleSet;
        }

        public List<ArtifactoryServer> getArtifactoryServers() {
            return RepositoriesUtils.getArtifactoryServers();
        }
    }
}

