/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm.perforce;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.scm.AbstractScmCoordinator;
import org.jfrog.hudson.release.scm.perforce.AbstractPerforceManager;
import org.jfrog.hudson.util.ExtractorUtils;

public class PerforceCoordinator
extends AbstractScmCoordinator {
    private static Logger debuggingLogger = Logger.getLogger(AbstractPerforceManager.class.getName());
    private AbstractPerforceManager perforce;
    private final ReleaseAction releaseAction;
    private boolean tagCreated;
    private int currentChangeListId;

    public PerforceCoordinator(AbstractBuild build, BuildListener listener, ReleaseAction releaseAction, AbstractPerforceManager perforce) {
        super(build, listener);
        this.perforce = perforce;
        this.releaseAction = releaseAction;
    }

    @Override
    public void prepare() throws IOException, InterruptedException {
        this.perforce.prepare();
    }

    @Override
    public void beforeReleaseVersionChange() throws IOException {
        this.currentChangeListId = this.perforce.createNewChangeList();
    }

    @Override
    public void afterSuccessfulReleaseVersionBuild() throws Exception {
        String labelChangeListId = ExtractorUtils.getVcsRevision((Map<String, String>)this.build.getEnvironment((TaskListener)this.listener));
        if (this.modifiedFilesForReleaseVersion) {
            this.log("Submitt  ing release version changes");
            labelChangeListId = this.currentChangeListId + "";
            this.perforce.commitWorkingCopy(this.currentChangeListId, this.releaseAction.getDefaultGlobalReleaseVersion());
        } else {
            this.safeRevertWorkingCopy();
            this.currentChangeListId = this.perforce.getDefaultChangeListId();
        }
        if (this.releaseAction.isCreateVcsTag()) {
            this.log("Creating label: '" + this.releaseAction.getTagUrl() + "' with change list id: " + labelChangeListId);
            this.perforce.createTag(this.releaseAction.getTagUrl(), this.releaseAction.getTagComment(), labelChangeListId);
            this.tagCreated = true;
        }
    }

    @Override
    public void beforeDevelopmentVersionChange() throws IOException, InterruptedException {
        this.currentChangeListId = this.perforce.getDefaultChangeListId();
    }

    @Override
    public void afterDevelopmentVersionChange(boolean modified) throws IOException, InterruptedException {
        super.afterDevelopmentVersionChange(modified);
        if (modified) {
            this.log("Submitting next development version changes");
            try {
                this.perforce.commitWorkingCopy(this.currentChangeListId, this.releaseAction.getNextDevelCommitComment());
            }
            catch (Exception e) {
                this.log("Error: " + e.getMessage());
            }
        } else {
            this.safeRevertWorkingCopy();
            this.currentChangeListId = this.perforce.getDefaultChangeListId();
        }
    }

    @Override
    public void edit(FilePath filePath) throws IOException, InterruptedException {
        try {
            this.perforce.edit(this.currentChangeListId, filePath);
        }
        catch (Exception e) {
            this.log("Error: " + e.getMessage());
        }
    }

    @Override
    public void buildCompleted() throws IOException, InterruptedException {
        if (!this.build.getResult().isBetterOrEqualTo(Result.SUCCESS)) {
            this.safeRevertWorkingCopy();
            if (this.tagCreated) {
                this.safeDeleteLabel();
            }
        } else {
            this.log("Closing connection to perforce server");
            this.perforce.closeConnection();
        }
    }

    private void safeRevertWorkingCopy() {
        this.log("Reverting local changes");
        try {
            this.perforce.revertWorkingCopy(this.currentChangeListId);
        }
        catch (Exception e) {
            debuggingLogger.log(Level.FINE, "Failed to revert: ", e);
            this.log("Failed to revert: " + e.getLocalizedMessage());
        }
    }

    private void safeDeleteLabel() throws IOException {
        this.log("Deleting label '" + this.releaseAction.getTagUrl() + "'");
        try {
            this.perforce.deleteLabel(this.releaseAction.getTagUrl());
        }
        catch (Exception e) {
            debuggingLogger.log(Level.FINE, "Failed to delete label: ", e);
            this.log("Failed to delete label: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String getRemoteUrlForPom() {
        return null;
    }
}

