/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm.perforce;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.server.IOptionsServer;
import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import org.apache.log4j.Logger;
import org.jenkinsci.plugins.p4.PerforceScm;
import org.jenkinsci.plugins.p4.client.ClientHelper;
import org.jenkinsci.plugins.p4.client.ConnectionFactory;
import org.jenkinsci.plugins.p4.client.ConnectionHelper;
import org.jfrog.build.vcs.perforce.PerforceClient;
import org.jfrog.hudson.release.scm.perforce.AbstractPerforceManager;

public class P4Manager
extends AbstractPerforceManager<PerforceScm> {
    private static Logger logger = Logger.getLogger(P4Manager.class);

    public P4Manager(AbstractBuild<?, ?> build, TaskListener buildListener) {
        super(build, buildListener);
    }

    @Override
    public void prepare() {
        PerforceScm perforceScm = (PerforceScm)this.getJenkinsScm();
        String credentials = perforceScm.getCredential();
        ConnectionHelper connection = new ConnectionHelper(credentials, this.buildListener);
        IOptionsServer server = ConnectionFactory.getConnection();
        try {
            String clientString = this.getClientString();
            if (connection.isClient(clientString)) {
                ClientHelper perforceClient = new ClientHelper(credentials, this.buildListener, clientString);
                IClient client = perforceClient.getClient();
                try {
                    this.perforce = new PerforceClient(server, client);
                    this.perforce.initConnection();
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not instantiate connection with PerforceClient: " + e.getMessage()));
                }
            } else {
                logger.warn((Object)("Client " + clientString + " is not a valid client."));
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error occurred: ", (Throwable)e);
        }
    }

    @Override
    public PerforceClient establishConnection() throws Exception {
        this.perforce.initConnection();
        return this.perforce;
    }

    private String getClientString() {
        String client = "";
        try {
            EnvVars envVars = this.build.getEnvironment(this.buildListener);
            client = (String)envVars.get((Object)"P4_CLIENT");
        }
        catch (Exception e) {
            logger.warn((Object)"P4: Unable to read P4_CLIENT");
        }
        return client;
    }
}

