/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.scm.git;

import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfrog.hudson.release.ReleaseAction;
import org.jfrog.hudson.release.ReleaseRepository;
import org.jfrog.hudson.release.scm.AbstractScmCoordinator;
import org.jfrog.hudson.release.scm.git.GitManager;

public class GitCoordinator
extends AbstractScmCoordinator {
    private static Logger debuggingLogger = Logger.getLogger(GitCoordinator.class.getName());
    private final ReleaseAction releaseAction;
    private GitManager scmManager;
    private String releaseBranch;
    private String checkoutBranch;
    private State state = new State();

    public GitCoordinator(AbstractBuild build, BuildListener listener, ReleaseAction releaseAction) {
        super(build, listener);
        this.releaseAction = releaseAction;
    }

    @Override
    public void prepare() throws IOException, InterruptedException {
        this.releaseBranch = this.releaseAction.getReleaseBranch();
        this.scmManager = new GitManager(this.build, (TaskListener)this.listener);
        this.scmManager.setGitCredentials(this.releaseAction.getGitCredentials());
        String gitBranchName = (String)this.build.getEnvironment((TaskListener)this.listener).get((Object)"GIT_BRANCH");
        this.checkoutBranch = this.scmManager.getBranchNameWithoutRemote(gitBranchName);
    }

    public void pushDryRun() throws Exception {
        if (this.releaseAction.isCreateVcsTag() && this.scmManager.isTagExists(this.scmManager.getRemoteConfig(this.releaseAction.getTargetRemoteName()), this.releaseAction.getTagUrl())) {
            throw new Exception(String.format("Tag with name '%s' already exists", this.releaseAction.getTagUrl()));
        }
        String testTagName = this.releaseAction.getTagUrl() + "_test";
        try {
            this.scmManager.testPush(this.scmManager.getRemoteConfig(this.releaseAction.getTargetRemoteName()), testTagName);
        }
        catch (Exception e) {
            throw new Exception(String.format("Failed while attempting push dry-run: %s", e.getMessage()), e);
        }
        finally {
            if (this.scmManager.isTagExists(this.scmManager.getRemoteConfig(this.releaseAction.getTargetRemoteName()), testTagName)) {
                this.scmManager.deleteLocalTag(testTagName);
            }
        }
    }

    @Override
    public void beforeReleaseVersionChange() throws IOException, InterruptedException {
        if (this.releaseAction.isCreateReleaseBranch()) {
            this.scmManager.checkoutBranch(this.releaseBranch, true);
            this.state.currentWorkingBranch = this.releaseBranch;
            this.state.releaseBranchCreated = true;
        } else {
            this.scmManager.checkoutBranch(this.checkoutBranch, false);
            this.state.currentWorkingBranch = this.checkoutBranch;
        }
    }

    @Override
    public void afterSuccessfulReleaseVersionBuild() throws Exception {
        if (this.modifiedFilesForReleaseVersion) {
            this.log(String.format("Committing release version on branch '%s'", this.state.currentWorkingBranch));
            this.scmManager.commitWorkingCopy(this.releaseAction.getTagComment());
        }
        if (this.releaseAction.isCreateVcsTag()) {
            this.scmManager.createTag(this.releaseAction.getTagUrl(), this.releaseAction.getTagComment());
            this.state.tagCreated = true;
        }
        if (this.modifiedFilesForReleaseVersion || this.releaseAction.isCreateReleaseBranch() || this.releaseAction.isCreateVcsTag()) {
            this.scmManager.push(this.scmManager.getRemoteConfig(this.releaseAction.getTargetRemoteName()), this.state.currentWorkingBranch);
            this.state.releaseBranchPushed = true;
        }
    }

    @Override
    public void beforeDevelopmentVersionChange() throws IOException, InterruptedException {
        if (this.releaseAction.isCreateReleaseBranch()) {
            this.scmManager.checkoutBranch(this.checkoutBranch, false);
            this.state.currentWorkingBranch = this.checkoutBranch;
        }
    }

    @Override
    public void afterDevelopmentVersionChange(boolean modified) throws IOException, InterruptedException {
        super.afterDevelopmentVersionChange(modified);
        if (modified) {
            this.log(String.format("Committing next development version on branch '%s'", this.state.currentWorkingBranch));
            this.scmManager.commitWorkingCopy(this.releaseAction.getNextDevelCommitComment());
        }
    }

    @Override
    public void buildCompleted() throws Exception {
        if (this.build.getResult().isBetterOrEqualTo(Result.SUCCESS)) {
            if (this.modifiedFilesForDevVersion) {
                this.scmManager.push(this.scmManager.getRemoteConfig(this.releaseAction.getTargetRemoteName()), this.state.currentWorkingBranch);
            }
        } else {
            this.scmManager.checkoutBranch(this.checkoutBranch, false);
            this.state.currentWorkingBranch = this.checkoutBranch;
            if (this.state.releaseBranchCreated) {
                this.safeDeleteBranch(this.releaseBranch);
            }
            if (this.state.releaseBranchPushed) {
                this.safeDeleteRemoteBranch(this.scmManager.getRemoteConfig(this.releaseAction.getTargetRemoteName()), this.releaseBranch);
            }
            if (this.state.tagCreated) {
                this.safeDeleteTag(this.releaseAction.getTagUrl());
            }
            this.safeRevertWorkingCopy();
        }
    }

    private void safeDeleteBranch(String branch) {
        try {
            this.scmManager.deleteLocalBranch(branch);
        }
        catch (Exception e) {
            debuggingLogger.log(Level.FINE, "Failed to delete release branch: ", e);
            this.log("Failed to delete release branch: " + e.getLocalizedMessage());
        }
    }

    private void safeDeleteRemoteBranch(ReleaseRepository remoteRepository, String branch) {
        try {
            this.scmManager.deleteRemoteBranch(remoteRepository, branch);
        }
        catch (Exception e) {
            debuggingLogger.log(Level.FINE, "Failed to delete remote release branch: ", e);
            this.log("Failed to delete remote release branch: " + e.getLocalizedMessage());
        }
    }

    private void safeDeleteTag(String tag) {
        try {
            this.scmManager.deleteLocalTag(tag);
        }
        catch (Exception e) {
            debuggingLogger.log(Level.FINE, "Failed to delete tag: ", e);
            this.log("Failed to delete tag: " + e.getLocalizedMessage());
        }
    }

    private void safeRevertWorkingCopy() {
        try {
            this.scmManager.revertWorkingCopy();
        }
        catch (Exception e) {
            debuggingLogger.log(Level.FINE, "Failed to revert working copy: ", e);
            this.log("Failed to revert working copy: " + e.getLocalizedMessage());
        }
    }

    @Override
    public String getRemoteUrlForPom() {
        return null;
    }

    private static class State {
        String currentWorkingBranch;
        boolean releaseBranchCreated;
        boolean releaseBranchPushed;
        boolean tagCreated;

        private State() {
        }
    }
}

