/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release.maven;

import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;

public class MavenModulesExtractor
extends MasterToSlaveFileCallable<List<String>> {
    public List<String> invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
        MavenProject mavenProject = this.getMavenProject(f.getAbsolutePath());
        return mavenProject.getModel().getModules();
    }

    private MavenProject getMavenProject(String pomFile) throws IOException {
        InputStreamReader reader = null;
        try {
            MavenXpp3Reader mavenReader = new MavenXpp3Reader();
            reader = new FileReader(pomFile);
            Model model = mavenReader.read((Reader)reader);
            model.setPomFile(new File(pomFile));
            MavenProject mavenProject = new MavenProject(model);
            return mavenProject;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

