/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.release;

import hudson.model.TaskListener;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.jfrog.build.api.builder.DistributionBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.hudson.util.ExtractorUtils;

public class DistributionUtils {
    public static boolean distributeAndCheckResponse(DistributionBuilder distributionBuilder, ArtifactoryBuildInfoClient client, TaskListener listener, String buildName, String buildNumber, boolean dryRun) throws IOException {
        listener.getLogger().println("Performing dry run distribution (no changes are made during dry run) ...");
        if (!DistributionUtils.distribute(distributionBuilder, client, listener, buildName, buildNumber, true)) {
            return false;
        }
        listener.getLogger().println("Dry run finished successfully");
        if (!dryRun) {
            listener.getLogger().println("Performing distribution ...");
            if (!DistributionUtils.distribute(distributionBuilder, client, listener, buildName, buildNumber, false)) {
                return false;
            }
            listener.getLogger().println("Distribution completed successfully!");
        }
        return true;
    }

    private static boolean distribute(DistributionBuilder distributionBuilder, ArtifactoryBuildInfoClient client, TaskListener listener, String buildName, String buildNumber, boolean dryRun) throws IOException {
        HttpResponse response = client.distributeBuild(buildName, buildNumber, distributionBuilder.dryRun(dryRun).build());
        return DistributionUtils.checkSuccess(response, dryRun, listener);
    }

    private static boolean checkSuccess(HttpResponse response, boolean dryRun, TaskListener listener) {
        StatusLine status = response.getStatusLine();
        String content = "";
        try {
            content = ExtractorUtils.entityToString(response.getEntity());
            ExtractorUtils.validateStringNotBlank(content);
            JSONObject json = JSONObject.fromObject((Object)content);
            String message = json.getString("message");
            if (DistributionUtils.assertResponseStatus(dryRun, listener, status, message)) {
                listener.getLogger().println(message);
                return true;
            }
        }
        catch (IOException e) {
            String parsingErrorStr = "Failed parsing distribution response";
            if (StringUtils.isNotBlank((String)content)) {
                parsingErrorStr = ": " + content;
            }
            e.printStackTrace(listener.error(parsingErrorStr));
        }
        return false;
    }

    private static boolean assertResponseStatus(boolean dryRun, TaskListener listener, StatusLine status, String message) {
        if (status.getStatusCode() != 200) {
            if (dryRun) {
                listener.error("Distribution failed during dry run (no change in Artifactory was done): " + status + "\n" + message);
            } else {
                listener.error("Distribution failed. View Artifactory logs for more details: " + status + "\n" + message);
            }
            return false;
        }
        return true;
    }
}

