/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ProxyConfiguration;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryXrayClient;
import org.jfrog.hudson.CredentialsConfig;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.XrayScanConfig;
import org.jfrog.hudson.pipeline.common.types.XrayScanResult;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class XrayScanBuildStep
extends AbstractStepImpl {
    private ArtifactoryServer server;
    private XrayScanConfig xrayScanConfig;

    @DataBoundConstructor
    public XrayScanBuildStep(XrayScanConfig xrayScanConfig, ArtifactoryServer server) {
        this.xrayScanConfig = xrayScanConfig;
        this.server = server;
    }

    public ArtifactoryServer getServer() {
        return this.server;
    }

    public XrayScanConfig getXrayScanConfig() {
        return this.xrayScanConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "xrayScanBuild";
        }

        public String getDisplayName() {
            return "Xray build scanning";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<XrayScanResult> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @Inject(optional=true)
        private transient XrayScanBuildStep step;

        protected XrayScanResult run() throws Exception {
            ArtifactoryXrayResponse buildScanResult;
            XrayScanResult xrayScanResult;
            XrayScanConfig xrayScanConfig = this.step.getXrayScanConfig();
            if (StringUtils.isEmpty((String)xrayScanConfig.getBuildName())) {
                throw new MissingArgumentException("Xray scan build name is mandatory");
            }
            if (StringUtils.isEmpty((String)xrayScanConfig.getBuildNumber())) {
                throw new MissingArgumentException("Xray scan build number is mandatory");
            }
            JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
            ArtifactoryServer server = this.step.getServer();
            CredentialsConfig credentialsConfig = server.createCredentialsConfig();
            ArtifactoryXrayClient client = new ArtifactoryXrayClient(server.getUrl(), credentialsConfig.provideUsername((Item)this.build.getParent()), credentialsConfig.providePassword((Item)this.build.getParent()), (Log)log);
            ProxyConfiguration proxyConfiguration = Utils.getProxyConfiguration(Utils.prepareArtifactoryServer(null, server));
            if (proxyConfiguration != null) {
                client.setProxyConfiguration(proxyConfiguration);
            }
            if ((xrayScanResult = new XrayScanResult(buildScanResult = client.xrayScanBuild(xrayScanConfig.getBuildName(), xrayScanConfig.getBuildNumber(), "jenkins"))).isFoundVulnerable()) {
                if (xrayScanConfig.getFailBuild()) {
                    this.build.setResult(Result.FAILURE);
                }
                log.error(xrayScanResult.getScanMessage());
            } else {
                log.info(xrayScanResult.getScanMessage());
            }
            if (StringUtils.isNotEmpty((String)xrayScanResult.getScanUrl())) {
                log.info("Xray scan details are available at: " + xrayScanResult.getScanUrl());
            }
            return xrayScanResult;
        }
    }
}

