/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.common.collect.ArrayListMultimap;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.Properties;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.build.api.Module;
import org.jfrog.hudson.pipeline.common.ArtifactoryConfigurator;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.docker.DockerImage;
import org.jfrog.hudson.pipeline.common.docker.utils.DockerAgentUtils;
import org.jfrog.hudson.pipeline.common.docker.utils.DockerUtils;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfoAccessor;
import org.jfrog.hudson.util.JenkinsBuildInfoLog;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerPushStep
extends AbstractStepImpl {
    private final String image;
    private final ArtifactoryServer server;
    private String host;
    private BuildInfo buildInfo;
    private String targetRepo;
    private ArrayListMultimap<String, String> properties;

    @DataBoundConstructor
    public DockerPushStep(String image, String host, String targetRepo, BuildInfo buildInfo, ArrayListMultimap<String, String> properties, ArtifactoryServer server) {
        this.image = image;
        this.host = host;
        this.targetRepo = targetRepo;
        this.buildInfo = buildInfo;
        this.properties = properties;
        this.server = server;
    }

    public ArtifactoryServer getServer() {
        return this.server;
    }

    public String getImage() {
        return this.image;
    }

    public ArrayListMultimap<String, String> getProperties() {
        return this.properties;
    }

    public String getHost() {
        return this.host;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getTargetRepo() {
        return this.targetRepo;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "dockerPushStep";
        }

        public String getDisplayName() {
            return "Artifactory docker push";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        @Inject(optional=true)
        private transient DockerPushStep step;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient Launcher launcher;

        protected BuildInfo run() throws Exception {
            if (this.step.getImage() == null) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Missing 'image' parameter"));
                return null;
            }
            if (this.step.getTargetRepo() == null) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Missing 'targetRepo' parameter"));
                return null;
            }
            JenkinsBuildInfoLog log = new JenkinsBuildInfoLog(this.listener);
            BuildInfo buildInfo = Utils.prepareBuildinfo(this.build, this.step.getBuildInfo());
            ArtifactoryServer server = this.step.getServer();
            String username = server.createCredentialsConfig().provideUsername((Item)this.build.getParent());
            String password = server.createCredentialsConfig().providePassword((Item)this.build.getParent());
            String imageId = DockerAgentUtils.getImageIdFromAgent(this.launcher, this.step.getImage(), this.step.getHost());
            DockerAgentUtils.pushImage(this.launcher, log, this.step.getImage(), username, password, this.step.getHost());
            DockerImage image = new DockerImage(imageId, this.step.getImage(), this.step.getTargetRepo(), buildInfo.hashCode(), (ArrayListMultimap<String, String>)this.step.properties);
            String parentId = DockerAgentUtils.getParentIdFromAgent(this.launcher, imageId, this.step.getHost());
            if (!StringUtils.isEmpty((String)parentId)) {
                Properties properties = new Properties();
                properties.put("docker.image.parent", DockerUtils.getShaValue(parentId));
                image.addBuildInfoModuleProps(properties);
            }
            String timestamp = Long.toString(buildInfo.getStartDate().getTime());
            ArtifactoryConfigurator config = new ArtifactoryConfigurator(Utils.prepareArtifactoryServer(null, server));
            Module module = image.generateBuildInfoModule(this.build, this.listener, config, buildInfo.getName(), buildInfo.getNumber(), timestamp);
            if (module.getArtifacts() == null || module.getArtifacts().size() == 0) {
                log.warn("Could not find docker image: " + this.step.getImage() + " in Artifactory.");
            }
            BuildInfoAccessor buildInfoAccessor = new BuildInfoAccessor(buildInfo);
            buildInfoAccessor.getModules().add(module);
            log.info("Successfully pushed docker image: " + this.step.getImage());
            return buildInfo;
        }
    }
}

