/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.Utils;
import org.jfrog.hudson.pipeline.common.executors.DistributionExecutor;
import org.jfrog.hudson.pipeline.common.types.ArtifactoryServer;
import org.jfrog.hudson.pipeline.common.types.DistributionConfig;
import org.kohsuke.stapler.DataBoundConstructor;

public class DistributeBuildStep
extends AbstractStepImpl {
    private ArtifactoryServer server;
    private DistributionConfig distributionConfig;

    @DataBoundConstructor
    public DistributeBuildStep(DistributionConfig distributionConfig, ArtifactoryServer server) {
        this.distributionConfig = distributionConfig;
        this.server = server;
    }

    public ArtifactoryServer getServer() {
        return this.server;
    }

    public DistributionConfig getDistributionConfig() {
        return this.distributionConfig;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "artifactoryDistributeBuild";
        }

        public String getDisplayName() {
            return "Distribute build";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Boolean> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @Inject(optional=true)
        private transient DistributeBuildStep step;

        protected Boolean run() throws Exception {
            DistributionConfig distributionConfig = this.step.getDistributionConfig();
            if (StringUtils.isEmpty((String)distributionConfig.getBuildName())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Distribution build name is mandatory"));
                return false;
            }
            if (StringUtils.isEmpty((String)distributionConfig.getBuildNumber())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Distribution build number is mandatory"));
                return false;
            }
            if (StringUtils.isEmpty((String)distributionConfig.getTargetRepo())) {
                this.getContext().onFailure((Throwable)new MissingArgumentException("Distribution target repository is mandatory"));
                return false;
            }
            new DistributionExecutor(Utils.prepareArtifactoryServer(null, this.step.getServer()), this.build, this.listener, this.getContext(), distributionConfig).execute();
            return true;
        }
    }
}

