/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.pipeline.scripted.steps;

import com.google.inject.Inject;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.jfrog.hudson.pipeline.common.executors.GradleExecutor;
import org.jfrog.hudson.pipeline.common.types.buildInfo.BuildInfo;
import org.jfrog.hudson.pipeline.common.types.packageManagerBuilds.GradleBuild;
import org.kohsuke.stapler.DataBoundConstructor;

public class ArtifactoryGradleBuild
extends AbstractStepImpl {
    private GradleBuild gradleBuild;
    private String tasks;
    private String buildFile;
    private String rootDir;
    private String switches;
    private BuildInfo buildInfo;

    @DataBoundConstructor
    public ArtifactoryGradleBuild(GradleBuild gradleBuild, String rootDir, String buildFile, String tasks, String switches, BuildInfo buildInfo) {
        this.gradleBuild = gradleBuild;
        this.tasks = tasks;
        this.rootDir = rootDir;
        this.buildFile = buildFile;
        this.switches = switches;
        this.buildInfo = buildInfo;
    }

    private GradleBuild getGradleBuild() {
        return this.gradleBuild;
    }

    private String getSwitches() {
        return this.switches;
    }

    private String getTasks() {
        return this.tasks;
    }

    private String getBuildFile() {
        return this.buildFile;
    }

    private BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    private String getRootDir() {
        return this.rootDir;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(Execution.class);
        }

        public String getFunctionName() {
            return "ArtifactoryGradleBuild";
        }

        public String getDisplayName() {
            return "run Artifactory gradle";
        }

        public boolean isAdvanced() {
            return true;
        }
    }

    public static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<BuildInfo> {
        private static final long serialVersionUID = 1L;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient Launcher launcher;
        @Inject(optional=true)
        private transient ArtifactoryGradleBuild step;
        @StepContextParameter
        private transient FilePath ws;
        @StepContextParameter
        private transient EnvVars env;

        protected BuildInfo run() throws Exception {
            GradleExecutor gradleExecutor = new GradleExecutor(this.build, this.step.getGradleBuild(), this.step.getTasks(), this.step.getBuildFile(), this.step.getRootDir(), this.step.getSwitches(), this.step.getBuildInfo(), this.env, this.ws, this.listener, this.launcher);
            gradleExecutor.execute();
            return gradleExecutor.getBuildInfo();
        }
    }
}

